// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Resources.Samples
{
    public partial class Sample_FeatureCollection
    {
        // List provider Features
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListProviderFeatures()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Features/stable/2021-07-01/examples/listProviderFeatures.json
            // this example is just showing the usage of "Features_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceProviderResource created on azure
            // for more information of creating ResourceProviderResource, please refer to the document of ResourceProviderResource
            string subscriptionId = "subid";
            string resourceProviderNamespace = "Resource Provider Namespace";
            ResourceIdentifier resourceProviderResourceId = ResourceProviderResource.CreateResourceIdentifier(subscriptionId, resourceProviderNamespace);
            ResourceProviderResource resourceProvider = client.GetResourceProviderResource(resourceProviderResourceId);

            // get the collection of this FeatureResource
            FeatureCollection collection = resourceProvider.GetFeatures();

            // invoke the operation and iterate over the result
            await foreach (FeatureResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                FeatureData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get feature
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetFeature()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Features/stable/2021-07-01/examples/getFeature.json
            // this example is just showing the usage of "Features_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceProviderResource created on azure
            // for more information of creating ResourceProviderResource, please refer to the document of ResourceProviderResource
            string subscriptionId = "subid";
            string resourceProviderNamespace = "Resource Provider Namespace";
            ResourceIdentifier resourceProviderResourceId = ResourceProviderResource.CreateResourceIdentifier(subscriptionId, resourceProviderNamespace);
            ResourceProviderResource resourceProvider = client.GetResourceProviderResource(resourceProviderResourceId);

            // get the collection of this FeatureResource
            FeatureCollection collection = resourceProvider.GetFeatures();

            // invoke the operation
            string featureName = "feature";
            FeatureResource result = await collection.GetAsync(featureName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FeatureData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get feature
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetFeature()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Features/stable/2021-07-01/examples/getFeature.json
            // this example is just showing the usage of "Features_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceProviderResource created on azure
            // for more information of creating ResourceProviderResource, please refer to the document of ResourceProviderResource
            string subscriptionId = "subid";
            string resourceProviderNamespace = "Resource Provider Namespace";
            ResourceIdentifier resourceProviderResourceId = ResourceProviderResource.CreateResourceIdentifier(subscriptionId, resourceProviderNamespace);
            ResourceProviderResource resourceProvider = client.GetResourceProviderResource(resourceProviderResourceId);

            // get the collection of this FeatureResource
            FeatureCollection collection = resourceProvider.GetFeatures();

            // invoke the operation
            string featureName = "feature";
            bool result = await collection.ExistsAsync(featureName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get feature
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetFeature()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Features/stable/2021-07-01/examples/getFeature.json
            // this example is just showing the usage of "Features_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceProviderResource created on azure
            // for more information of creating ResourceProviderResource, please refer to the document of ResourceProviderResource
            string subscriptionId = "subid";
            string resourceProviderNamespace = "Resource Provider Namespace";
            ResourceIdentifier resourceProviderResourceId = ResourceProviderResource.CreateResourceIdentifier(subscriptionId, resourceProviderNamespace);
            ResourceProviderResource resourceProvider = client.GetResourceProviderResource(resourceProviderResourceId);

            // get the collection of this FeatureResource
            FeatureCollection collection = resourceProvider.GetFeatures();

            // invoke the operation
            string featureName = "feature";
            NullableResponse<FeatureResource> response = await collection.GetIfExistsAsync(featureName);
            FeatureResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                FeatureData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
