// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Resources.Samples
{
    public partial class Sample_DataPolicyManifestResource
    {
        // Retrieve a data policy manifest by policy mode
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RetrieveADataPolicyManifestByPolicyMode()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2020-09-01/examples/getDataPolicyManifest.json
            // this example is just showing the usage of "DataPolicyManifests_GetByPolicyMode" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataPolicyManifestResource created on azure
            // for more information of creating DataPolicyManifestResource, please refer to the document of DataPolicyManifestResource
            string policyMode = "Microsoft.KeyVault.Data";
            ResourceIdentifier dataPolicyManifestResourceId = DataPolicyManifestResource.CreateResourceIdentifier(policyMode);
            DataPolicyManifestResource dataPolicyManifest = client.GetDataPolicyManifestResource(dataPolicyManifestResourceId);

            // invoke the operation
            DataPolicyManifestResource result = await dataPolicyManifest.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataPolicyManifestData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
