// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Resources.Samples
{
    public partial class Sample_DataPolicyManifestCollection
    {
        // Retrieve a data policy manifest by policy mode
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RetrieveADataPolicyManifestByPolicyMode()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2020-09-01/examples/getDataPolicyManifest.json
            // this example is just showing the usage of "DataPolicyManifests_GetByPolicyMode" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenant = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // get the collection of this DataPolicyManifestResource
            DataPolicyManifestCollection collection = tenant.GetDataPolicyManifests();

            // invoke the operation
            string policyMode = "Microsoft.KeyVault.Data";
            DataPolicyManifestResource result = await collection.GetAsync(policyMode);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataPolicyManifestData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Retrieve a data policy manifest by policy mode
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_RetrieveADataPolicyManifestByPolicyMode()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2020-09-01/examples/getDataPolicyManifest.json
            // this example is just showing the usage of "DataPolicyManifests_GetByPolicyMode" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenant = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // get the collection of this DataPolicyManifestResource
            DataPolicyManifestCollection collection = tenant.GetDataPolicyManifests();

            // invoke the operation
            string policyMode = "Microsoft.KeyVault.Data";
            bool result = await collection.ExistsAsync(policyMode);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Retrieve a data policy manifest by policy mode
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_RetrieveADataPolicyManifestByPolicyMode()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2020-09-01/examples/getDataPolicyManifest.json
            // this example is just showing the usage of "DataPolicyManifests_GetByPolicyMode" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenant = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // get the collection of this DataPolicyManifestResource
            DataPolicyManifestCollection collection = tenant.GetDataPolicyManifests();

            // invoke the operation
            string policyMode = "Microsoft.KeyVault.Data";
            NullableResponse<DataPolicyManifestResource> response = await collection.GetIfExistsAsync(policyMode);
            DataPolicyManifestResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DataPolicyManifestData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // List data policy manifests
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListDataPolicyManifests()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2020-09-01/examples/listDataPolicyManifests.json
            // this example is just showing the usage of "DataPolicyManifests_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenant = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // get the collection of this DataPolicyManifestResource
            DataPolicyManifestCollection collection = tenant.GetDataPolicyManifests();

            // invoke the operation and iterate over the result
            await foreach (DataPolicyManifestResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DataPolicyManifestData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // List data policy manifests with namespace filter
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListDataPolicyManifestsWithNamespaceFilter()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2020-09-01/examples/listDataPolicyManifestsNamespaceFilter.json
            // this example is just showing the usage of "DataPolicyManifests_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenant = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // get the collection of this DataPolicyManifestResource
            DataPolicyManifestCollection collection = tenant.GetDataPolicyManifests();

            // invoke the operation and iterate over the result
            string filter = "namespace eq 'Microsoft.KeyVault'";
            await foreach (DataPolicyManifestResource item in collection.GetAllAsync(filter: filter))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DataPolicyManifestData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
