// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.ResourceHealth.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.ResourceHealth
{
    /// <summary>
    /// A Class representing a ServiceEmergingIssue along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="ServiceEmergingIssueResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetServiceEmergingIssueResource method.
    /// Otherwise you can get one from its parent resource <see cref="TenantResource"/> using the GetServiceEmergingIssue method.
    /// </summary>
    public partial class ServiceEmergingIssueResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="ServiceEmergingIssueResource"/> instance. </summary>
        /// <param name="issueName"> The issueName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(EmergingIssueNameContent issueName)
        {
            var resourceId = $"/providers/Microsoft.ResourceHealth/emergingIssues/{issueName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _serviceEmergingIssueEmergingIssuesClientDiagnostics;
        private readonly EmergingIssuesRestOperations _serviceEmergingIssueEmergingIssuesRestClient;
        private readonly ServiceEmergingIssueData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.ResourceHealth/emergingIssues";

        /// <summary> Initializes a new instance of the <see cref="ServiceEmergingIssueResource"/> class for mocking. </summary>
        protected ServiceEmergingIssueResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ServiceEmergingIssueResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal ServiceEmergingIssueResource(ArmClient client, ServiceEmergingIssueData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="ServiceEmergingIssueResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal ServiceEmergingIssueResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _serviceEmergingIssueEmergingIssuesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ResourceHealth", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string serviceEmergingIssueEmergingIssuesApiVersion);
            _serviceEmergingIssueEmergingIssuesRestClient = new EmergingIssuesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, serviceEmergingIssueEmergingIssuesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual ServiceEmergingIssueData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets Azure services' emerging issues.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.ResourceHealth/emergingIssues/{issueName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmergingIssues_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceEmergingIssueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ServiceEmergingIssueResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _serviceEmergingIssueEmergingIssuesClientDiagnostics.CreateScope("ServiceEmergingIssueResource.Get");
            scope.Start();
            try
            {
                var response = await _serviceEmergingIssueEmergingIssuesRestClient.GetAsync(Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServiceEmergingIssueResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets Azure services' emerging issues.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.ResourceHealth/emergingIssues/{issueName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmergingIssues_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceEmergingIssueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ServiceEmergingIssueResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _serviceEmergingIssueEmergingIssuesClientDiagnostics.CreateScope("ServiceEmergingIssueResource.Get");
            scope.Start();
            try
            {
                var response = _serviceEmergingIssueEmergingIssuesRestClient.Get(Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServiceEmergingIssueResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
