// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.ResourceHealth.Models;

namespace Azure.ResourceManager.ResourceHealth
{
    /// <summary>
    /// A class representing the ServiceEmergingIssue data model.
    /// The Get EmergingIssues operation response.
    /// </summary>
    public partial class ServiceEmergingIssueData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServiceEmergingIssueData"/>. </summary>
        internal ServiceEmergingIssueData()
        {
            StatusBanners = new ChangeTrackingList<EmergingIssueBannerType>();
            StatusActiveEvents = new ChangeTrackingList<EmergingIssueActiveEventType>();
        }

        /// <summary> Initializes a new instance of <see cref="ServiceEmergingIssueData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="refreshedOn"> Timestamp for when last time refreshed for ongoing emerging issue. </param>
        /// <param name="statusBanners"> The list of emerging issues of banner type. </param>
        /// <param name="statusActiveEvents"> The list of emerging issues of active event type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServiceEmergingIssueData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DateTimeOffset? refreshedOn, IReadOnlyList<EmergingIssueBannerType> statusBanners, IReadOnlyList<EmergingIssueActiveEventType> statusActiveEvents, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            RefreshedOn = refreshedOn;
            StatusBanners = statusBanners;
            StatusActiveEvents = statusActiveEvents;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Timestamp for when last time refreshed for ongoing emerging issue. </summary>
        public DateTimeOffset? RefreshedOn { get; }
        /// <summary> The list of emerging issues of banner type. </summary>
        public IReadOnlyList<EmergingIssueBannerType> StatusBanners { get; }
        /// <summary> The list of emerging issues of active event type. </summary>
        public IReadOnlyList<EmergingIssueActiveEventType> StatusActiveEvents { get; }
    }
}
