// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.ResourceHealth.Models;

namespace Azure.ResourceManager.ResourceHealth
{
    /// <summary>
    /// A class representing the ResourceHealthMetadataEntity data model.
    /// The metadata entity contract.
    /// </summary>
    public partial class ResourceHealthMetadataEntityData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceHealthMetadataEntityData"/>. </summary>
        internal ResourceHealthMetadataEntityData()
        {
            DependsOn = new ChangeTrackingList<string>();
            ApplicableScenarios = new ChangeTrackingList<MetadataEntityScenario>();
            SupportedValues = new ChangeTrackingList<MetadataSupportedValueDetail>();
        }

        /// <summary> Initializes a new instance of <see cref="ResourceHealthMetadataEntityData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="displayName"> The display name. </param>
        /// <param name="dependsOn"> The list of keys on which this entity depends on. </param>
        /// <param name="applicableScenarios"> The list of scenarios applicable to this metadata entity. </param>
        /// <param name="supportedValues"> The list of supported values. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceHealthMetadataEntityData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string displayName, IReadOnlyList<string> dependsOn, IReadOnlyList<MetadataEntityScenario> applicableScenarios, IReadOnlyList<MetadataSupportedValueDetail> supportedValues, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            DisplayName = displayName;
            DependsOn = dependsOn;
            ApplicableScenarios = applicableScenarios;
            SupportedValues = supportedValues;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The display name. </summary>
        public string DisplayName { get; }
        /// <summary> The list of keys on which this entity depends on. </summary>
        public IReadOnlyList<string> DependsOn { get; }
        /// <summary> The list of scenarios applicable to this metadata entity. </summary>
        public IReadOnlyList<MetadataEntityScenario> ApplicableScenarios { get; }
        /// <summary> The list of supported values. </summary>
        public IReadOnlyList<MetadataSupportedValueDetail> SupportedValues { get; }
    }
}
