// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.ResourceHealth.Models;

namespace Azure.ResourceManager.ResourceHealth
{
    /// <summary>
    /// A class representing the ResourceHealthEventImpactedResource data model.
    /// Impacted resource for an event.
    /// </summary>
    public partial class ResourceHealthEventImpactedResourceData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceHealthEventImpactedResourceData"/>. </summary>
        internal ResourceHealthEventImpactedResourceData()
        {
            Info = new ChangeTrackingList<ResourceHealthKeyValueItem>();
        }

        /// <summary> Initializes a new instance of <see cref="ResourceHealthEventImpactedResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="targetResourceType"> Resource type within Microsoft cloud. </param>
        /// <param name="targetResourceId"> Identity for resource within Microsoft cloud. </param>
        /// <param name="targetRegion"> Impacted resource region name. </param>
        /// <param name="resourceName"> Resource name of the impacted resource. </param>
        /// <param name="resourceGroup"> Resource group name of the impacted resource. </param>
        /// <param name="status"> Status of the impacted resource. </param>
        /// <param name="maintenanceStartTime"> Start time of maintenance for the impacted resource. </param>
        /// <param name="maintenanceEndTime"> End time of maintenance for the impacted resource. </param>
        /// <param name="info"> Additional information. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceHealthEventImpactedResourceData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, ResourceType? targetResourceType, ResourceIdentifier targetResourceId, string targetRegion, string resourceName, string resourceGroup, string status, string maintenanceStartTime, string maintenanceEndTime, IReadOnlyList<ResourceHealthKeyValueItem> info, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            TargetResourceType = targetResourceType;
            TargetResourceId = targetResourceId;
            TargetRegion = targetRegion;
            ResourceName = resourceName;
            ResourceGroup = resourceGroup;
            Status = status;
            MaintenanceStartTime = maintenanceStartTime;
            MaintenanceEndTime = maintenanceEndTime;
            Info = info;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource type within Microsoft cloud. </summary>
        public ResourceType? TargetResourceType { get; }
        /// <summary> Identity for resource within Microsoft cloud. </summary>
        public ResourceIdentifier TargetResourceId { get; }
        /// <summary> Impacted resource region name. </summary>
        public string TargetRegion { get; }
        /// <summary> Resource name of the impacted resource. </summary>
        public string ResourceName { get; }
        /// <summary> Resource group name of the impacted resource. </summary>
        public string ResourceGroup { get; }
        /// <summary> Status of the impacted resource. </summary>
        public string Status { get; }
        /// <summary> Start time of maintenance for the impacted resource. </summary>
        public string MaintenanceStartTime { get; }
        /// <summary> End time of maintenance for the impacted resource. </summary>
        public string MaintenanceEndTime { get; }
        /// <summary> Additional information. </summary>
        public IReadOnlyList<ResourceHealthKeyValueItem> Info { get; }
    }
}
