// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.ResourceHealth.Models;

namespace Azure.ResourceManager.ResourceHealth
{
    /// <summary>
    /// A class representing the ResourceHealthEvent data model.
    /// Service health event
    /// </summary>
    public partial class ResourceHealthEventData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceHealthEventData"/>. </summary>
        internal ResourceHealthEventData()
        {
            Links = new ChangeTrackingList<ResourceHealthEventLink>();
            Impact = new ChangeTrackingList<ResourceHealthEventImpact>();
            Faqs = new ChangeTrackingList<ResourceHealthEventFaq>();
        }

        /// <summary> Initializes a new instance of <see cref="ResourceHealthEventData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="eventType"> Type of event. </param>
        /// <param name="eventSubType"> Sub type of the event. Currently used to determine retirement communications for health advisory events. </param>
        /// <param name="eventSource"> Source of event. </param>
        /// <param name="status"> Current status of event. </param>
        /// <param name="title"> Title text of event. </param>
        /// <param name="summary"> Summary text of event. </param>
        /// <param name="header"> Header text of event. </param>
        /// <param name="level"> Level of insight. </param>
        /// <param name="eventLevel"> Level of event. </param>
        /// <param name="externalIncidentId"> The id of the Incident. </param>
        /// <param name="reason"> The reason for the Incident. </param>
        /// <param name="article"> Article of event. </param>
        /// <param name="links"> Useful links of event. </param>
        /// <param name="impactStartOn"> It provides the Timestamp for when the health impacting event started. </param>
        /// <param name="impactMitigationOn"> It provides the Timestamp for when the health impacting event resolved. </param>
        /// <param name="impact"> List services impacted by the service health event. </param>
        /// <param name="recommendedActions"> Recommended actions of event. </param>
        /// <param name="faqs"> Frequently asked questions for the service health event. </param>
        /// <param name="isHirEvent"> It provides information if the event is High incident rate event or not. </param>
        /// <param name="isMicrosoftSupportEnabled"> Tells if we want to enable or disable Microsoft Support for this event. </param>
        /// <param name="description"> Contains the communication message for the event, that could include summary, root cause and other details. </param>
        /// <param name="isPlatformInitiated"> Is true if the event is platform initiated. </param>
        /// <param name="isChatWithUsEnabled"> Tells if we want to enable or disable Microsoft Support for this event. </param>
        /// <param name="priority"> Priority level of the event. Has value from 0 to 23. 0 is the highest priority. Service issue events have higher priority followed by planned maintenance and health advisory. Critical events have higher priority followed by error, warning and informational. Furthermore, active events have higher priority than resolved. </param>
        /// <param name="lastUpdateOn"> It provides the Timestamp for when the health impacting event was last updated. </param>
        /// <param name="hirStage"> Stage for HIR Document. </param>
        /// <param name="additionalInformation"> Additional information. </param>
        /// <param name="duration"> duration in seconds. </param>
        /// <param name="impactType"> The type of the impact. </param>
        /// <param name="maintenanceId"> Unique identifier for planned maintenance event. </param>
        /// <param name="maintenanceType"> The type of planned maintenance event. </param>
        /// <param name="argQuery"> Azure Resource Graph query to fetch the affected resources from their existing Azure Resource Graph locations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceHealthEventData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, ResourceHealthEventTypeValue? eventType, EventSubTypeValue? eventSubType, ResourceHealthEventSourceValue? eventSource, ResourceHealthEventStatusValue? status, string title, string summary, string header, ResourceHealthEventInsightLevelValue? level, ResourceHealthEventLevelValue? eventLevel, string externalIncidentId, string reason, ResourceHealthEventArticle article, IReadOnlyList<ResourceHealthEventLink> links, DateTimeOffset? impactStartOn, DateTimeOffset? impactMitigationOn, IReadOnlyList<ResourceHealthEventImpact> impact, ResourceHealthEventRecommendedActions recommendedActions, IReadOnlyList<ResourceHealthEventFaq> faqs, bool? isHirEvent, bool? isMicrosoftSupportEnabled, string description, bool? isPlatformInitiated, bool? isChatWithUsEnabled, int? priority, DateTimeOffset? lastUpdateOn, string hirStage, ResourceHealthEventAdditionalInformation additionalInformation, int? duration, string impactType, string maintenanceId, string maintenanceType, string argQuery, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            EventType = eventType;
            EventSubType = eventSubType;
            EventSource = eventSource;
            Status = status;
            Title = title;
            Summary = summary;
            Header = header;
            Level = level;
            EventLevel = eventLevel;
            ExternalIncidentId = externalIncidentId;
            Reason = reason;
            Article = article;
            Links = links;
            ImpactStartOn = impactStartOn;
            ImpactMitigationOn = impactMitigationOn;
            Impact = impact;
            RecommendedActions = recommendedActions;
            Faqs = faqs;
            IsHirEvent = isHirEvent;
            IsMicrosoftSupportEnabled = isMicrosoftSupportEnabled;
            Description = description;
            IsPlatformInitiated = isPlatformInitiated;
            IsChatWithUsEnabled = isChatWithUsEnabled;
            Priority = priority;
            LastUpdateOn = lastUpdateOn;
            HirStage = hirStage;
            AdditionalInformation = additionalInformation;
            Duration = duration;
            ImpactType = impactType;
            MaintenanceId = maintenanceId;
            MaintenanceType = maintenanceType;
            ArgQuery = argQuery;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of event. </summary>
        public ResourceHealthEventTypeValue? EventType { get; }
        /// <summary> Sub type of the event. Currently used to determine retirement communications for health advisory events. </summary>
        public EventSubTypeValue? EventSubType { get; }
        /// <summary> Source of event. </summary>
        public ResourceHealthEventSourceValue? EventSource { get; }
        /// <summary> Current status of event. </summary>
        public ResourceHealthEventStatusValue? Status { get; }
        /// <summary> Title text of event. </summary>
        public string Title { get; }
        /// <summary> Summary text of event. </summary>
        public string Summary { get; }
        /// <summary> Header text of event. </summary>
        public string Header { get; }
        /// <summary> Level of insight. </summary>
        public ResourceHealthEventInsightLevelValue? Level { get; }
        /// <summary> Level of event. </summary>
        public ResourceHealthEventLevelValue? EventLevel { get; }
        /// <summary> The id of the Incident. </summary>
        public string ExternalIncidentId { get; }
        /// <summary> The reason for the Incident. </summary>
        public string Reason { get; }
        /// <summary> Article of event. </summary>
        public ResourceHealthEventArticle Article { get; }
        /// <summary> Useful links of event. </summary>
        public IReadOnlyList<ResourceHealthEventLink> Links { get; }
        /// <summary> It provides the Timestamp for when the health impacting event started. </summary>
        public DateTimeOffset? ImpactStartOn { get; }
        /// <summary> It provides the Timestamp for when the health impacting event resolved. </summary>
        public DateTimeOffset? ImpactMitigationOn { get; }
        /// <summary> List services impacted by the service health event. </summary>
        public IReadOnlyList<ResourceHealthEventImpact> Impact { get; }
        /// <summary> Recommended actions of event. </summary>
        public ResourceHealthEventRecommendedActions RecommendedActions { get; }
        /// <summary> Frequently asked questions for the service health event. </summary>
        public IReadOnlyList<ResourceHealthEventFaq> Faqs { get; }
        /// <summary> It provides information if the event is High incident rate event or not. </summary>
        public bool? IsHirEvent { get; }
        /// <summary> Tells if we want to enable or disable Microsoft Support for this event. </summary>
        public bool? IsMicrosoftSupportEnabled { get; }
        /// <summary> Contains the communication message for the event, that could include summary, root cause and other details. </summary>
        public string Description { get; }
        /// <summary> Is true if the event is platform initiated. </summary>
        public bool? IsPlatformInitiated { get; }
        /// <summary> Tells if we want to enable or disable Microsoft Support for this event. </summary>
        public bool? IsChatWithUsEnabled { get; }
        /// <summary> Priority level of the event. Has value from 0 to 23. 0 is the highest priority. Service issue events have higher priority followed by planned maintenance and health advisory. Critical events have higher priority followed by error, warning and informational. Furthermore, active events have higher priority than resolved. </summary>
        public int? Priority { get; }
        /// <summary> It provides the Timestamp for when the health impacting event was last updated. </summary>
        public DateTimeOffset? LastUpdateOn { get; }
        /// <summary> Stage for HIR Document. </summary>
        public string HirStage { get; }
        /// <summary> Additional information. </summary>
        internal ResourceHealthEventAdditionalInformation AdditionalInformation { get; }
        /// <summary> Additional information Message. </summary>
        public string AdditionalInformationMessage
        {
            get => AdditionalInformation?.Message;
        }

        /// <summary> duration in seconds. </summary>
        public int? Duration { get; }
        /// <summary> The type of the impact. </summary>
        public string ImpactType { get; }
        /// <summary> Unique identifier for planned maintenance event. </summary>
        public string MaintenanceId { get; }
        /// <summary> The type of planned maintenance event. </summary>
        public string MaintenanceType { get; }
        /// <summary> Azure Resource Graph query to fetch the affected resources from their existing Azure Resource Graph locations. </summary>
        public string ArgQuery { get; }
    }
}
