// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.ResourceHealth.Models;

namespace Azure.ResourceManager.ResourceHealth
{
    public partial class ResourceHealthEventData : IUtf8JsonSerializable, IJsonModel<ResourceHealthEventData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ResourceHealthEventData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ResourceHealthEventData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceHealthEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResourceHealthEventData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(EventType))
            {
                writer.WritePropertyName("eventType"u8);
                writer.WriteStringValue(EventType.Value.ToString());
            }
            if (Optional.IsDefined(EventSubType))
            {
                writer.WritePropertyName("eventSubType"u8);
                writer.WriteStringValue(EventSubType.Value.ToString());
            }
            if (Optional.IsDefined(EventSource))
            {
                writer.WritePropertyName("eventSource"u8);
                writer.WriteStringValue(EventSource.Value.ToString());
            }
            if (Optional.IsDefined(Status))
            {
                writer.WritePropertyName("status"u8);
                writer.WriteStringValue(Status.Value.ToString());
            }
            if (Optional.IsDefined(Title))
            {
                writer.WritePropertyName("title"u8);
                writer.WriteStringValue(Title);
            }
            if (Optional.IsDefined(Summary))
            {
                writer.WritePropertyName("summary"u8);
                writer.WriteStringValue(Summary);
            }
            if (Optional.IsDefined(Header))
            {
                writer.WritePropertyName("header"u8);
                writer.WriteStringValue(Header);
            }
            if (Optional.IsDefined(Level))
            {
                writer.WritePropertyName("level"u8);
                writer.WriteStringValue(Level.Value.ToString());
            }
            if (Optional.IsDefined(EventLevel))
            {
                writer.WritePropertyName("eventLevel"u8);
                writer.WriteStringValue(EventLevel.Value.ToString());
            }
            if (Optional.IsDefined(ExternalIncidentId))
            {
                writer.WritePropertyName("externalIncidentId"u8);
                writer.WriteStringValue(ExternalIncidentId);
            }
            if (Optional.IsDefined(Reason))
            {
                writer.WritePropertyName("reason"u8);
                writer.WriteStringValue(Reason);
            }
            if (Optional.IsDefined(Article))
            {
                writer.WritePropertyName("article"u8);
                writer.WriteObjectValue(Article, options);
            }
            if (Optional.IsCollectionDefined(Links))
            {
                writer.WritePropertyName("links"u8);
                writer.WriteStartArray();
                foreach (var item in Links)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(ImpactStartOn))
            {
                writer.WritePropertyName("impactStartTime"u8);
                writer.WriteStringValue(ImpactStartOn.Value, "O");
            }
            if (Optional.IsDefined(ImpactMitigationOn))
            {
                writer.WritePropertyName("impactMitigationTime"u8);
                writer.WriteStringValue(ImpactMitigationOn.Value, "O");
            }
            if (Optional.IsCollectionDefined(Impact))
            {
                writer.WritePropertyName("impact"u8);
                writer.WriteStartArray();
                foreach (var item in Impact)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(RecommendedActions))
            {
                writer.WritePropertyName("recommendedActions"u8);
                writer.WriteObjectValue(RecommendedActions, options);
            }
            if (Optional.IsCollectionDefined(Faqs))
            {
                writer.WritePropertyName("faqs"u8);
                writer.WriteStartArray();
                foreach (var item in Faqs)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(IsHirEvent))
            {
                writer.WritePropertyName("isHIR"u8);
                writer.WriteBooleanValue(IsHirEvent.Value);
            }
            if (Optional.IsDefined(IsMicrosoftSupportEnabled))
            {
                writer.WritePropertyName("enableMicrosoftSupport"u8);
                writer.WriteBooleanValue(IsMicrosoftSupportEnabled.Value);
            }
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsDefined(IsPlatformInitiated))
            {
                writer.WritePropertyName("platformInitiated"u8);
                writer.WriteBooleanValue(IsPlatformInitiated.Value);
            }
            if (Optional.IsDefined(IsChatWithUsEnabled))
            {
                writer.WritePropertyName("enableChatWithUs"u8);
                writer.WriteBooleanValue(IsChatWithUsEnabled.Value);
            }
            if (Optional.IsDefined(Priority))
            {
                writer.WritePropertyName("priority"u8);
                writer.WriteNumberValue(Priority.Value);
            }
            if (Optional.IsDefined(LastUpdateOn))
            {
                writer.WritePropertyName("lastUpdateTime"u8);
                writer.WriteStringValue(LastUpdateOn.Value, "O");
            }
            if (Optional.IsDefined(HirStage))
            {
                writer.WritePropertyName("hirStage"u8);
                writer.WriteStringValue(HirStage);
            }
            if (Optional.IsDefined(AdditionalInformation))
            {
                writer.WritePropertyName("additionalInformation"u8);
                writer.WriteObjectValue(AdditionalInformation, options);
            }
            if (Optional.IsDefined(Duration))
            {
                writer.WritePropertyName("duration"u8);
                writer.WriteNumberValue(Duration.Value);
            }
            if (Optional.IsDefined(ImpactType))
            {
                writer.WritePropertyName("impactType"u8);
                writer.WriteStringValue(ImpactType);
            }
            if (Optional.IsDefined(MaintenanceId))
            {
                writer.WritePropertyName("maintenanceId"u8);
                writer.WriteStringValue(MaintenanceId);
            }
            if (Optional.IsDefined(MaintenanceType))
            {
                writer.WritePropertyName("maintenanceType"u8);
                writer.WriteStringValue(MaintenanceType);
            }
            if (Optional.IsDefined(ArgQuery))
            {
                writer.WritePropertyName("argQuery"u8);
                writer.WriteStringValue(ArgQuery);
            }
            writer.WriteEndObject();
        }

        ResourceHealthEventData IJsonModel<ResourceHealthEventData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceHealthEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResourceHealthEventData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeResourceHealthEventData(document.RootElement, options);
        }

        internal static ResourceHealthEventData DeserializeResourceHealthEventData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            ResourceHealthEventTypeValue? eventType = default;
            EventSubTypeValue? eventSubType = default;
            ResourceHealthEventSourceValue? eventSource = default;
            ResourceHealthEventStatusValue? status = default;
            string title = default;
            string summary = default;
            string header = default;
            ResourceHealthEventInsightLevelValue? level = default;
            ResourceHealthEventLevelValue? eventLevel = default;
            string externalIncidentId = default;
            string reason = default;
            ResourceHealthEventArticle article = default;
            IReadOnlyList<ResourceHealthEventLink> links = default;
            DateTimeOffset? impactStartTime = default;
            DateTimeOffset? impactMitigationTime = default;
            IReadOnlyList<ResourceHealthEventImpact> impact = default;
            ResourceHealthEventRecommendedActions recommendedActions = default;
            IReadOnlyList<ResourceHealthEventFaq> faqs = default;
            bool? isHIR = default;
            bool? enableMicrosoftSupport = default;
            string description = default;
            bool? platformInitiated = default;
            bool? enableChatWithUs = default;
            int? priority = default;
            DateTimeOffset? lastUpdateTime = default;
            string hirStage = default;
            ResourceHealthEventAdditionalInformation additionalInformation = default;
            int? duration = default;
            string impactType = default;
            string maintenanceId = default;
            string maintenanceType = default;
            string argQuery = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("eventType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            eventType = new ResourceHealthEventTypeValue(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("eventSubType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            eventSubType = new EventSubTypeValue(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("eventSource"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            eventSource = new ResourceHealthEventSourceValue(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("status"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            status = new ResourceHealthEventStatusValue(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("title"u8))
                        {
                            title = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("summary"u8))
                        {
                            summary = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("header"u8))
                        {
                            header = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("level"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            level = new ResourceHealthEventInsightLevelValue(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("eventLevel"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            eventLevel = new ResourceHealthEventLevelValue(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("externalIncidentId"u8))
                        {
                            externalIncidentId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("reason"u8))
                        {
                            reason = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("article"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            article = ResourceHealthEventArticle.DeserializeResourceHealthEventArticle(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("links"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ResourceHealthEventLink> array = new List<ResourceHealthEventLink>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ResourceHealthEventLink.DeserializeResourceHealthEventLink(item, options));
                            }
                            links = array;
                            continue;
                        }
                        if (property0.NameEquals("impactStartTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            impactStartTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("impactMitigationTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            impactMitigationTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("impact"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ResourceHealthEventImpact> array = new List<ResourceHealthEventImpact>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ResourceHealthEventImpact.DeserializeResourceHealthEventImpact(item, options));
                            }
                            impact = array;
                            continue;
                        }
                        if (property0.NameEquals("recommendedActions"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            recommendedActions = ResourceHealthEventRecommendedActions.DeserializeResourceHealthEventRecommendedActions(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("faqs"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ResourceHealthEventFaq> array = new List<ResourceHealthEventFaq>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ResourceHealthEventFaq.DeserializeResourceHealthEventFaq(item, options));
                            }
                            faqs = array;
                            continue;
                        }
                        if (property0.NameEquals("isHIR"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isHIR = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("enableMicrosoftSupport"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableMicrosoftSupport = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("description"u8))
                        {
                            description = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("platformInitiated"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            platformInitiated = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("enableChatWithUs"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableChatWithUs = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("priority"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            priority = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("lastUpdateTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            lastUpdateTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("hirStage"u8))
                        {
                            hirStage = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("additionalInformation"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            additionalInformation = ResourceHealthEventAdditionalInformation.DeserializeResourceHealthEventAdditionalInformation(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("duration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            duration = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("impactType"u8))
                        {
                            impactType = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("maintenanceId"u8))
                        {
                            maintenanceId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("maintenanceType"u8))
                        {
                            maintenanceType = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("argQuery"u8))
                        {
                            argQuery = property0.Value.GetString();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ResourceHealthEventData(
                id,
                name,
                type,
                systemData,
                eventType,
                eventSubType,
                eventSource,
                status,
                title,
                summary,
                header,
                level,
                eventLevel,
                externalIncidentId,
                reason,
                article,
                links ?? new ChangeTrackingList<ResourceHealthEventLink>(),
                impactStartTime,
                impactMitigationTime,
                impact ?? new ChangeTrackingList<ResourceHealthEventImpact>(),
                recommendedActions,
                faqs ?? new ChangeTrackingList<ResourceHealthEventFaq>(),
                isHIR,
                enableMicrosoftSupport,
                description,
                platformInitiated,
                enableChatWithUs,
                priority,
                lastUpdateTime,
                hirStage,
                additionalInformation,
                duration,
                impactType,
                maintenanceId,
                maintenanceType,
                argQuery,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ResourceHealthEventData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceHealthEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ResourceHealthEventData)} does not support writing '{options.Format}' format.");
            }
        }

        ResourceHealthEventData IPersistableModel<ResourceHealthEventData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceHealthEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeResourceHealthEventData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ResourceHealthEventData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ResourceHealthEventData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
