// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    /// <summary> Lists the service impacting events that may be affecting the health of the resource. </summary>
    public partial class ServiceImpactingEvent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServiceImpactingEvent"/>. </summary>
        internal ServiceImpactingEvent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ServiceImpactingEvent"/>. </summary>
        /// <param name="eventStartOn"> Timestamp for when the event started. </param>
        /// <param name="eventStatusLastModifiedOn"> Timestamp for when event was submitted/detected. </param>
        /// <param name="correlationId"> Correlation id for the event. </param>
        /// <param name="status"> Status of the service impacting event. </param>
        /// <param name="incidentProperties"> Properties of the service impacting event. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServiceImpactingEvent(DateTimeOffset? eventStartOn, DateTimeOffset? eventStatusLastModifiedOn, string correlationId, ServiceImpactingEventStatus status, ServiceImpactingEventIncidentProperties incidentProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EventStartOn = eventStartOn;
            EventStatusLastModifiedOn = eventStatusLastModifiedOn;
            CorrelationId = correlationId;
            Status = status;
            IncidentProperties = incidentProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Timestamp for when the event started. </summary>
        public DateTimeOffset? EventStartOn { get; }
        /// <summary> Timestamp for when event was submitted/detected. </summary>
        public DateTimeOffset? EventStatusLastModifiedOn { get; }
        /// <summary> Correlation id for the event. </summary>
        public string CorrelationId { get; }
        /// <summary> Status of the service impacting event. </summary>
        internal ServiceImpactingEventStatus Status { get; }
        /// <summary> Current status of the event. </summary>
        public string StatusValue
        {
            get => Status?.Value;
        }

        /// <summary> Properties of the service impacting event. </summary>
        public ServiceImpactingEventIncidentProperties IncidentProperties { get; }
    }
}
