// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    /// <summary> Lists actions the user can take based on the current availabilityState of the resource. </summary>
    public partial class ResourceHealthRecommendedAction
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceHealthRecommendedAction"/>. </summary>
        internal ResourceHealthRecommendedAction()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ResourceHealthRecommendedAction"/>. </summary>
        /// <param name="action"> Recommended action. </param>
        /// <param name="actionUri"> Link to the action. </param>
        /// <param name="actionUriComment"> the comment for the Action. </param>
        /// <param name="actionUriText"> Substring of action, it describes which text should host the action URL. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceHealthRecommendedAction(string action, Uri actionUri, string actionUriComment, string actionUriText, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Action = action;
            ActionUri = actionUri;
            ActionUriComment = actionUriComment;
            ActionUriText = actionUriText;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Recommended action. </summary>
        public string Action { get; }
        /// <summary> Link to the action. </summary>
        public Uri ActionUri { get; }
        /// <summary> the comment for the Action. </summary>
        public string ActionUriComment { get; }
        /// <summary> Substring of action, it describes which text should host the action URL. </summary>
        public string ActionUriText { get; }
    }
}
