// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    /// <summary> Type of event. </summary>
    public readonly partial struct ResourceHealthEventTypeValue : IEquatable<ResourceHealthEventTypeValue>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceHealthEventTypeValue"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceHealthEventTypeValue(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ServiceIssueValue = "ServiceIssue";
        private const string PlannedMaintenanceValue = "PlannedMaintenance";
        private const string HealthAdvisoryValue = "HealthAdvisory";
        private const string RcaValue = "RCA";
        private const string EmergingIssuesValue = "EmergingIssues";
        private const string SecurityAdvisoryValue = "SecurityAdvisory";

        /// <summary> ServiceIssue. </summary>
        public static ResourceHealthEventTypeValue ServiceIssue { get; } = new ResourceHealthEventTypeValue(ServiceIssueValue);
        /// <summary> PlannedMaintenance. </summary>
        public static ResourceHealthEventTypeValue PlannedMaintenance { get; } = new ResourceHealthEventTypeValue(PlannedMaintenanceValue);
        /// <summary> HealthAdvisory. </summary>
        public static ResourceHealthEventTypeValue HealthAdvisory { get; } = new ResourceHealthEventTypeValue(HealthAdvisoryValue);
        /// <summary> RCA. </summary>
        public static ResourceHealthEventTypeValue Rca { get; } = new ResourceHealthEventTypeValue(RcaValue);
        /// <summary> EmergingIssues. </summary>
        public static ResourceHealthEventTypeValue EmergingIssues { get; } = new ResourceHealthEventTypeValue(EmergingIssuesValue);
        /// <summary> SecurityAdvisory. </summary>
        public static ResourceHealthEventTypeValue SecurityAdvisory { get; } = new ResourceHealthEventTypeValue(SecurityAdvisoryValue);
        /// <summary> Determines if two <see cref="ResourceHealthEventTypeValue"/> values are the same. </summary>
        public static bool operator ==(ResourceHealthEventTypeValue left, ResourceHealthEventTypeValue right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceHealthEventTypeValue"/> values are not the same. </summary>
        public static bool operator !=(ResourceHealthEventTypeValue left, ResourceHealthEventTypeValue right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceHealthEventTypeValue"/>. </summary>
        public static implicit operator ResourceHealthEventTypeValue(string value) => new ResourceHealthEventTypeValue(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceHealthEventTypeValue other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceHealthEventTypeValue other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
