// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    /// <summary> Current status of event. </summary>
    public readonly partial struct ResourceHealthEventStatusValue : IEquatable<ResourceHealthEventStatusValue>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceHealthEventStatusValue"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceHealthEventStatusValue(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string ResolvedValue = "Resolved";

        /// <summary> Active. </summary>
        public static ResourceHealthEventStatusValue Active { get; } = new ResourceHealthEventStatusValue(ActiveValue);
        /// <summary> Resolved. </summary>
        public static ResourceHealthEventStatusValue Resolved { get; } = new ResourceHealthEventStatusValue(ResolvedValue);
        /// <summary> Determines if two <see cref="ResourceHealthEventStatusValue"/> values are the same. </summary>
        public static bool operator ==(ResourceHealthEventStatusValue left, ResourceHealthEventStatusValue right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceHealthEventStatusValue"/> values are not the same. </summary>
        public static bool operator !=(ResourceHealthEventStatusValue left, ResourceHealthEventStatusValue right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceHealthEventStatusValue"/>. </summary>
        public static implicit operator ResourceHealthEventStatusValue(string value) => new ResourceHealthEventStatusValue(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceHealthEventStatusValue other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceHealthEventStatusValue other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
