// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    /// <summary> The stage of this active event. </summary>
    public readonly partial struct ResourceHealthEventStageValue : IEquatable<ResourceHealthEventStageValue>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceHealthEventStageValue"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceHealthEventStageValue(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string ResolveValue = "Resolve";
        private const string ArchivedValue = "Archived";

        /// <summary> Active. </summary>
        public static ResourceHealthEventStageValue Active { get; } = new ResourceHealthEventStageValue(ActiveValue);
        /// <summary> Resolve. </summary>
        public static ResourceHealthEventStageValue Resolve { get; } = new ResourceHealthEventStageValue(ResolveValue);
        /// <summary> Archived. </summary>
        public static ResourceHealthEventStageValue Archived { get; } = new ResourceHealthEventStageValue(ArchivedValue);
        /// <summary> Determines if two <see cref="ResourceHealthEventStageValue"/> values are the same. </summary>
        public static bool operator ==(ResourceHealthEventStageValue left, ResourceHealthEventStageValue right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceHealthEventStageValue"/> values are not the same. </summary>
        public static bool operator !=(ResourceHealthEventStageValue left, ResourceHealthEventStageValue right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceHealthEventStageValue"/>. </summary>
        public static implicit operator ResourceHealthEventStageValue(string value) => new ResourceHealthEventStageValue(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceHealthEventStageValue other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceHealthEventStageValue other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
