// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    /// <summary> Source of event. </summary>
    public readonly partial struct ResourceHealthEventSourceValue : IEquatable<ResourceHealthEventSourceValue>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceHealthEventSourceValue"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceHealthEventSourceValue(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ResourceHealthValue = "ResourceHealth";
        private const string ServiceHealthValue = "ServiceHealth";

        /// <summary> ResourceHealth. </summary>
        public static ResourceHealthEventSourceValue ResourceHealth { get; } = new ResourceHealthEventSourceValue(ResourceHealthValue);
        /// <summary> ServiceHealth. </summary>
        public static ResourceHealthEventSourceValue ServiceHealth { get; } = new ResourceHealthEventSourceValue(ServiceHealthValue);
        /// <summary> Determines if two <see cref="ResourceHealthEventSourceValue"/> values are the same. </summary>
        public static bool operator ==(ResourceHealthEventSourceValue left, ResourceHealthEventSourceValue right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceHealthEventSourceValue"/> values are not the same. </summary>
        public static bool operator !=(ResourceHealthEventSourceValue left, ResourceHealthEventSourceValue right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceHealthEventSourceValue"/>. </summary>
        public static implicit operator ResourceHealthEventSourceValue(string value) => new ResourceHealthEventSourceValue(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceHealthEventSourceValue other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceHealthEventSourceValue other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
