// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    /// <summary> Recommended actions of event. </summary>
    public partial class ResourceHealthEventRecommendedActions
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceHealthEventRecommendedActions"/>. </summary>
        internal ResourceHealthEventRecommendedActions()
        {
            Actions = new ChangeTrackingList<ResourceHealthEventRecommendedActionsItem>();
        }

        /// <summary> Initializes a new instance of <see cref="ResourceHealthEventRecommendedActions"/>. </summary>
        /// <param name="message"> Recommended action title for the service health event. </param>
        /// <param name="actions"> Recommended actions for the service health event. </param>
        /// <param name="localeCode"> Recommended action locale for the service health event. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceHealthEventRecommendedActions(string message, IReadOnlyList<ResourceHealthEventRecommendedActionsItem> actions, string localeCode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Message = message;
            Actions = actions;
            LocaleCode = localeCode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Recommended action title for the service health event. </summary>
        public string Message { get; }
        /// <summary> Recommended actions for the service health event. </summary>
        public IReadOnlyList<ResourceHealthEventRecommendedActionsItem> Actions { get; }
        /// <summary> Recommended action locale for the service health event. </summary>
        public string LocaleCode { get; }
    }
}
