// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    /// <summary> Azure region impacted by the service health event. </summary>
    public partial class ResourceHealthEventImpactedServiceRegion
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceHealthEventImpactedServiceRegion"/>. </summary>
        internal ResourceHealthEventImpactedServiceRegion()
        {
            ImpactedSubscriptions = new ChangeTrackingList<string>();
            ImpactedTenants = new ChangeTrackingList<string>();
            Updates = new ChangeTrackingList<ResourceHealthEventUpdate>();
        }

        /// <summary> Initializes a new instance of <see cref="ResourceHealthEventImpactedServiceRegion"/>. </summary>
        /// <param name="impactedRegion"> Impacted region name. </param>
        /// <param name="status"> Current status of event in the region. </param>
        /// <param name="impactedSubscriptions"> List subscription impacted by the service health event. </param>
        /// <param name="impactedTenants"> List tenant impacted by the service health event. </param>
        /// <param name="lastUpdateOn"> It provides the Timestamp for when the last update for the service health event. </param>
        /// <param name="updates"> List of updates for given service health event. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceHealthEventImpactedServiceRegion(string impactedRegion, ResourceHealthEventStatusValue? status, IReadOnlyList<string> impactedSubscriptions, IReadOnlyList<string> impactedTenants, DateTimeOffset? lastUpdateOn, IReadOnlyList<ResourceHealthEventUpdate> updates, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ImpactedRegion = impactedRegion;
            Status = status;
            ImpactedSubscriptions = impactedSubscriptions;
            ImpactedTenants = impactedTenants;
            LastUpdateOn = lastUpdateOn;
            Updates = updates;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Impacted region name. </summary>
        public string ImpactedRegion { get; }
        /// <summary> Current status of event in the region. </summary>
        public ResourceHealthEventStatusValue? Status { get; }
        /// <summary> List subscription impacted by the service health event. </summary>
        public IReadOnlyList<string> ImpactedSubscriptions { get; }
        /// <summary> List tenant impacted by the service health event. </summary>
        public IReadOnlyList<string> ImpactedTenants { get; }
        /// <summary> It provides the Timestamp for when the last update for the service health event. </summary>
        public DateTimeOffset? LastUpdateOn { get; }
        /// <summary> List of updates for given service health event. </summary>
        public IReadOnlyList<ResourceHealthEventUpdate> Updates { get; }
    }
}
