// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    /// <summary> Frequently asked question for the service health event. </summary>
    public partial class ResourceHealthEventFaq
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceHealthEventFaq"/>. </summary>
        internal ResourceHealthEventFaq()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ResourceHealthEventFaq"/>. </summary>
        /// <param name="question"> FAQ question for the service health event. </param>
        /// <param name="answer"> FAQ answer for the service health event. </param>
        /// <param name="localeCode"> FAQ locale for the service health event. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceHealthEventFaq(string question, string answer, string localeCode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Question = question;
            Answer = answer;
            LocaleCode = localeCode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> FAQ question for the service health event. </summary>
        public string Question { get; }
        /// <summary> FAQ answer for the service health event. </summary>
        public string Answer { get; }
        /// <summary> FAQ locale for the service health event. </summary>
        public string LocaleCode { get; }
    }
}
