// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    public partial class ResourceHealthAvailabilityStatusProperties : IUtf8JsonSerializable, IJsonModel<ResourceHealthAvailabilityStatusProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ResourceHealthAvailabilityStatusProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ResourceHealthAvailabilityStatusProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceHealthAvailabilityStatusProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResourceHealthAvailabilityStatusProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(AvailabilityState))
            {
                writer.WritePropertyName("availabilityState"u8);
                writer.WriteStringValue(AvailabilityState.Value.ToString());
            }
            if (Optional.IsDefined(Title))
            {
                writer.WritePropertyName("title"u8);
                writer.WriteStringValue(Title);
            }
            if (Optional.IsDefined(Summary))
            {
                writer.WritePropertyName("summary"u8);
                writer.WriteStringValue(Summary);
            }
            if (Optional.IsDefined(DetailedStatus))
            {
                writer.WritePropertyName("detailedStatus"u8);
                writer.WriteStringValue(DetailedStatus);
            }
            if (Optional.IsDefined(ReasonType))
            {
                writer.WritePropertyName("reasonType"u8);
                writer.WriteStringValue(ReasonType);
            }
            if (Optional.IsDefined(Context))
            {
                writer.WritePropertyName("context"u8);
                writer.WriteStringValue(Context);
            }
            if (Optional.IsDefined(Category))
            {
                writer.WritePropertyName("category"u8);
                writer.WriteStringValue(Category);
            }
            if (Optional.IsDefined(ArticleId))
            {
                writer.WritePropertyName("articleId"u8);
                writer.WriteStringValue(ArticleId);
            }
            if (Optional.IsDefined(RootCauseAttributionOn))
            {
                writer.WritePropertyName("rootCauseAttributionTime"u8);
                writer.WriteStringValue(RootCauseAttributionOn.Value, "O");
            }
            if (Optional.IsDefined(HealthEventType))
            {
                writer.WritePropertyName("healthEventType"u8);
                writer.WriteStringValue(HealthEventType);
            }
            if (Optional.IsDefined(HealthEventCause))
            {
                writer.WritePropertyName("healthEventCause"u8);
                writer.WriteStringValue(HealthEventCause);
            }
            if (Optional.IsDefined(HealthEventCategory))
            {
                writer.WritePropertyName("healthEventCategory"u8);
                writer.WriteStringValue(HealthEventCategory);
            }
            if (Optional.IsDefined(HealthEventId))
            {
                writer.WritePropertyName("healthEventId"u8);
                writer.WriteStringValue(HealthEventId);
            }
            if (Optional.IsDefined(ResolutionEta))
            {
                writer.WritePropertyName("resolutionETA"u8);
                writer.WriteStringValue(ResolutionEta.Value, "O");
            }
            if (Optional.IsDefined(OccuredOn))
            {
                writer.WritePropertyName("occuredTime"u8);
                writer.WriteStringValue(OccuredOn.Value, "O");
            }
            if (Optional.IsDefined(ReasonChronicity))
            {
                writer.WritePropertyName("reasonChronicity"u8);
                writer.WriteStringValue(ReasonChronicity.Value.ToString());
            }
            if (Optional.IsDefined(ReportedOn))
            {
                writer.WritePropertyName("reportedTime"u8);
                writer.WriteStringValue(ReportedOn.Value, "O");
            }
            if (Optional.IsDefined(RecentlyResolved))
            {
                writer.WritePropertyName("recentlyResolved"u8);
                writer.WriteObjectValue(RecentlyResolved, options);
            }
            if (Optional.IsCollectionDefined(RecommendedActions))
            {
                writer.WritePropertyName("recommendedActions"u8);
                writer.WriteStartArray();
                foreach (var item in RecommendedActions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ServiceImpactingEvents))
            {
                writer.WritePropertyName("serviceImpactingEvents"u8);
                writer.WriteStartArray();
                foreach (var item in ServiceImpactingEvents)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ResourceHealthAvailabilityStatusProperties IJsonModel<ResourceHealthAvailabilityStatusProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceHealthAvailabilityStatusProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResourceHealthAvailabilityStatusProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeResourceHealthAvailabilityStatusProperties(document.RootElement, options);
        }

        internal static ResourceHealthAvailabilityStatusProperties DeserializeResourceHealthAvailabilityStatusProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceHealthAvailabilityStateValue? availabilityState = default;
            string title = default;
            string summary = default;
            string detailedStatus = default;
            string reasonType = default;
            string context = default;
            string category = default;
            string articleId = default;
            DateTimeOffset? rootCauseAttributionTime = default;
            string healthEventType = default;
            string healthEventCause = default;
            string healthEventCategory = default;
            string healthEventId = default;
            DateTimeOffset? resolutionETA = default;
            DateTimeOffset? occuredTime = default;
            ReasonChronicityType? reasonChronicity = default;
            DateTimeOffset? reportedTime = default;
            ResourceHealthAvailabilityStateRecentlyResolved recentlyResolved = default;
            IReadOnlyList<ResourceHealthRecommendedAction> recommendedActions = default;
            IReadOnlyList<ServiceImpactingEvent> serviceImpactingEvents = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("availabilityState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    availabilityState = new ResourceHealthAvailabilityStateValue(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("title"u8))
                {
                    title = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("summary"u8))
                {
                    summary = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("detailedStatus"u8))
                {
                    detailedStatus = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("reasonType"u8))
                {
                    reasonType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("context"u8))
                {
                    context = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("category"u8))
                {
                    category = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("articleId"u8))
                {
                    articleId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("rootCauseAttributionTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rootCauseAttributionTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("healthEventType"u8))
                {
                    healthEventType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("healthEventCause"u8))
                {
                    healthEventCause = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("healthEventCategory"u8))
                {
                    healthEventCategory = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("healthEventId"u8))
                {
                    healthEventId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("resolutionETA"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resolutionETA = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("occuredTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    occuredTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("reasonChronicity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    reasonChronicity = new ReasonChronicityType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("reportedTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    reportedTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("recentlyResolved"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recentlyResolved = ResourceHealthAvailabilityStateRecentlyResolved.DeserializeResourceHealthAvailabilityStateRecentlyResolved(property.Value, options);
                    continue;
                }
                if (property.NameEquals("recommendedActions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ResourceHealthRecommendedAction> array = new List<ResourceHealthRecommendedAction>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ResourceHealthRecommendedAction.DeserializeResourceHealthRecommendedAction(item, options));
                    }
                    recommendedActions = array;
                    continue;
                }
                if (property.NameEquals("serviceImpactingEvents"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ServiceImpactingEvent> array = new List<ServiceImpactingEvent>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ServiceImpactingEvent.DeserializeServiceImpactingEvent(item, options));
                    }
                    serviceImpactingEvents = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ResourceHealthAvailabilityStatusProperties(
                availabilityState,
                title,
                summary,
                detailedStatus,
                reasonType,
                context,
                category,
                articleId,
                rootCauseAttributionTime,
                healthEventType,
                healthEventCause,
                healthEventCategory,
                healthEventId,
                resolutionETA,
                occuredTime,
                reasonChronicity,
                reportedTime,
                recentlyResolved,
                recommendedActions ?? new ChangeTrackingList<ResourceHealthRecommendedAction>(),
                serviceImpactingEvents ?? new ChangeTrackingList<ServiceImpactingEvent>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ResourceHealthAvailabilityStatusProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceHealthAvailabilityStatusProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ResourceHealthAvailabilityStatusProperties)} does not support writing '{options.Format}' format.");
            }
        }

        ResourceHealthAvailabilityStatusProperties IPersistableModel<ResourceHealthAvailabilityStatusProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceHealthAvailabilityStatusProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeResourceHealthAvailabilityStatusProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ResourceHealthAvailabilityStatusProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ResourceHealthAvailabilityStatusProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
