// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    public partial class ResourceHealthAvailabilityStateRecentlyResolved : IUtf8JsonSerializable, IJsonModel<ResourceHealthAvailabilityStateRecentlyResolved>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ResourceHealthAvailabilityStateRecentlyResolved>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ResourceHealthAvailabilityStateRecentlyResolved>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceHealthAvailabilityStateRecentlyResolved>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResourceHealthAvailabilityStateRecentlyResolved)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(UnavailableOccuredOn))
            {
                writer.WritePropertyName("unavailableOccuredTime"u8);
                writer.WriteStringValue(UnavailableOccuredOn.Value, "O");
            }
            if (Optional.IsDefined(ResolvedOn))
            {
                writer.WritePropertyName("resolvedTime"u8);
                writer.WriteStringValue(ResolvedOn.Value, "O");
            }
            if (Optional.IsDefined(UnavailableSummary))
            {
                writer.WritePropertyName("unavailableSummary"u8);
                writer.WriteStringValue(UnavailableSummary);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ResourceHealthAvailabilityStateRecentlyResolved IJsonModel<ResourceHealthAvailabilityStateRecentlyResolved>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceHealthAvailabilityStateRecentlyResolved>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResourceHealthAvailabilityStateRecentlyResolved)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeResourceHealthAvailabilityStateRecentlyResolved(document.RootElement, options);
        }

        internal static ResourceHealthAvailabilityStateRecentlyResolved DeserializeResourceHealthAvailabilityStateRecentlyResolved(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? unavailableOccuredTime = default;
            DateTimeOffset? resolvedTime = default;
            string unavailableSummary = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("unavailableOccuredTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    unavailableOccuredTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("resolvedTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resolvedTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("unavailableSummary"u8))
                {
                    unavailableSummary = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ResourceHealthAvailabilityStateRecentlyResolved(unavailableOccuredTime, resolvedTime, unavailableSummary, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ResourceHealthAvailabilityStateRecentlyResolved>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceHealthAvailabilityStateRecentlyResolved>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ResourceHealthAvailabilityStateRecentlyResolved)} does not support writing '{options.Format}' format.");
            }
        }

        ResourceHealthAvailabilityStateRecentlyResolved IPersistableModel<ResourceHealthAvailabilityStateRecentlyResolved>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceHealthAvailabilityStateRecentlyResolved>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeResourceHealthAvailabilityStateRecentlyResolved(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ResourceHealthAvailabilityStateRecentlyResolved)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ResourceHealthAvailabilityStateRecentlyResolved>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
