// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    /// <summary> The metadata supported value detail. </summary>
    public partial class MetadataSupportedValueDetail
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MetadataSupportedValueDetail"/>. </summary>
        internal MetadataSupportedValueDetail()
        {
            ResourceTypes = new ChangeTrackingList<ResourceType>();
        }

        /// <summary> Initializes a new instance of <see cref="MetadataSupportedValueDetail"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="displayName"> The display name. </param>
        /// <param name="resourceTypes"> The list of associated resource types. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MetadataSupportedValueDetail(string id, string displayName, IReadOnlyList<ResourceType> resourceTypes, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            DisplayName = displayName;
            ResourceTypes = resourceTypes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The id. </summary>
        public string Id { get; }
        /// <summary> The display name. </summary>
        public string DisplayName { get; }
        /// <summary> The list of associated resource types. </summary>
        public IReadOnlyList<ResourceType> ResourceTypes { get; }
    }
}
