// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    /// <summary> The MetadataEntityScenario. </summary>
    public readonly partial struct MetadataEntityScenario : IEquatable<MetadataEntityScenario>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MetadataEntityScenario"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MetadataEntityScenario(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AlertsValue = "Alerts";

        /// <summary> Alerts. </summary>
        public static MetadataEntityScenario Alerts { get; } = new MetadataEntityScenario(AlertsValue);
        /// <summary> Determines if two <see cref="MetadataEntityScenario"/> values are the same. </summary>
        public static bool operator ==(MetadataEntityScenario left, MetadataEntityScenario right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MetadataEntityScenario"/> values are not the same. </summary>
        public static bool operator !=(MetadataEntityScenario left, MetadataEntityScenario right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MetadataEntityScenario"/>. </summary>
        public static implicit operator MetadataEntityScenario(string value) => new MetadataEntityScenario(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MetadataEntityScenario other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MetadataEntityScenario other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
