// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    /// <summary> Sub type of the event. Currently used to determine retirement communications for health advisory events. </summary>
    public readonly partial struct EventSubTypeValue : IEquatable<EventSubTypeValue>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventSubTypeValue"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventSubTypeValue(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RetirementValue = "Retirement";

        /// <summary> Retirement. </summary>
        public static EventSubTypeValue Retirement { get; } = new EventSubTypeValue(RetirementValue);
        /// <summary> Determines if two <see cref="EventSubTypeValue"/> values are the same. </summary>
        public static bool operator ==(EventSubTypeValue left, EventSubTypeValue right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventSubTypeValue"/> values are not the same. </summary>
        public static bool operator !=(EventSubTypeValue left, EventSubTypeValue right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventSubTypeValue"/>. </summary>
        public static implicit operator EventSubTypeValue(string value) => new EventSubTypeValue(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventSubTypeValue other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventSubTypeValue other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
