// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    /// <summary> Object of the emerging issue impact on services and regions. </summary>
    public partial class EmergingIssueImpact
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EmergingIssueImpact"/>. </summary>
        internal EmergingIssueImpact()
        {
            Regions = new ChangeTrackingList<EmergingIssueImpactedRegion>();
        }

        /// <summary> Initializes a new instance of <see cref="EmergingIssueImpact"/>. </summary>
        /// <param name="id"> The impacted service id. </param>
        /// <param name="name"> The impacted service name. </param>
        /// <param name="regions"> The list of impacted regions for corresponding emerging issues. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EmergingIssueImpact(string id, string name, IReadOnlyList<EmergingIssueImpactedRegion> regions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Name = name;
            Regions = regions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The impacted service id. </summary>
        public string Id { get; }
        /// <summary> The impacted service name. </summary>
        public string Name { get; }
        /// <summary> The list of impacted regions for corresponding emerging issues. </summary>
        public IReadOnlyList<EmergingIssueImpactedRegion> Regions { get; }
    }
}
