// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    /// <summary> Banner type of emerging issue. </summary>
    public partial class EmergingIssueBannerType
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EmergingIssueBannerType"/>. </summary>
        internal EmergingIssueBannerType()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EmergingIssueBannerType"/>. </summary>
        /// <param name="title"> The banner title. </param>
        /// <param name="message"> The details of banner. </param>
        /// <param name="cloud"> The cloud type of this banner. </param>
        /// <param name="lastModifiedOn"> The last time modified on this banner. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EmergingIssueBannerType(string title, string message, string cloud, DateTimeOffset? lastModifiedOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Title = title;
            Message = message;
            Cloud = cloud;
            LastModifiedOn = lastModifiedOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The banner title. </summary>
        public string Title { get; }
        /// <summary> The details of banner. </summary>
        public string Message { get; }
        /// <summary> The cloud type of this banner. </summary>
        public string Cloud { get; }
        /// <summary> The last time modified on this banner. </summary>
        public DateTimeOffset? LastModifiedOn { get; }
    }
}
