// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    /// <summary> Active event type of emerging issue. </summary>
    public partial class EmergingIssueActiveEventType
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EmergingIssueActiveEventType"/>. </summary>
        internal EmergingIssueActiveEventType()
        {
            Impacts = new ChangeTrackingList<EmergingIssueImpact>();
        }

        /// <summary> Initializes a new instance of <see cref="EmergingIssueActiveEventType"/>. </summary>
        /// <param name="title"> The active event title. </param>
        /// <param name="description"> The details of active event. </param>
        /// <param name="trackingId"> The tracking id of this active event. </param>
        /// <param name="startOn"> The impact start time on this active event. </param>
        /// <param name="cloud"> The cloud type of this active event. </param>
        /// <param name="severity"> The severity level of this active event. </param>
        /// <param name="stage"> The stage of this active event. </param>
        /// <param name="isPublished"> The boolean value of this active event if published or not. </param>
        /// <param name="lastModifiedOn"> The last time modified on this banner. </param>
        /// <param name="impacts"> The list of emerging issues impacts. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EmergingIssueActiveEventType(string title, string description, string trackingId, DateTimeOffset? startOn, string cloud, ResourceHealthEventSeverityLevel? severity, ResourceHealthEventStageValue? stage, bool? isPublished, DateTimeOffset? lastModifiedOn, IReadOnlyList<EmergingIssueImpact> impacts, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Title = title;
            Description = description;
            TrackingId = trackingId;
            StartOn = startOn;
            Cloud = cloud;
            Severity = severity;
            Stage = stage;
            IsPublished = isPublished;
            LastModifiedOn = lastModifiedOn;
            Impacts = impacts;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The active event title. </summary>
        public string Title { get; }
        /// <summary> The details of active event. </summary>
        public string Description { get; }
        /// <summary> The tracking id of this active event. </summary>
        public string TrackingId { get; }
        /// <summary> The impact start time on this active event. </summary>
        public DateTimeOffset? StartOn { get; }
        /// <summary> The cloud type of this active event. </summary>
        public string Cloud { get; }
        /// <summary> The severity level of this active event. </summary>
        public ResourceHealthEventSeverityLevel? Severity { get; }
        /// <summary> The stage of this active event. </summary>
        public ResourceHealthEventStageValue? Stage { get; }
        /// <summary> The boolean value of this active event if published or not. </summary>
        public bool? IsPublished { get; }
        /// <summary> The last time modified on this banner. </summary>
        public DateTimeOffset? LastModifiedOn { get; }
        /// <summary> The list of emerging issues impacts. </summary>
        public IReadOnlyList<EmergingIssueImpact> Impacts { get; }
    }
}
