// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ResourceHealth.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmResourceHealthModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.ResourceHealthAvailabilityStatus"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Azure Resource Manager geo location of the resource. </param>
        /// <param name="properties"> Properties of availability state. </param>
        /// <returns> A new <see cref="Models.ResourceHealthAvailabilityStatus"/> instance for mocking. </returns>
        public static ResourceHealthAvailabilityStatus ResourceHealthAvailabilityStatus(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, ResourceHealthAvailabilityStatusProperties properties = null)
        {
            return new ResourceHealthAvailabilityStatus(
                id,
                name,
                resourceType,
                systemData,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceHealthAvailabilityStatusProperties"/>. </summary>
        /// <param name="availabilityState"> Availability status of the resource. When it is null, this availabilityStatus object represents an availability impacting event. </param>
        /// <param name="title"> Title description of the availability status. </param>
        /// <param name="summary"> Summary description of the availability status. </param>
        /// <param name="detailedStatus"> Details of the availability status. </param>
        /// <param name="reasonType"> When the resource's availabilityState is Unavailable, it describes where the health impacting event was originated. Examples are planned, unplanned, user initiated or an outage etc. </param>
        /// <param name="context"> When an event is created, it can either be triggered by a customer or the platform of the resource and this field will illustrate that. This field is connected to the category field in this object. </param>
        /// <param name="category"> When a context field is set to Platform, this field will reflect if the event was planned or unplanned. If the context field does not have a value of Platform, then this field will be ignored. </param>
        /// <param name="articleId"> The Article Id. </param>
        /// <param name="rootCauseAttributionOn"> When the resource's availabilityState is Unavailable, it provides the Timestamp for when the health impacting event was received. </param>
        /// <param name="healthEventType"> In case of an availability impacting event, it describes when the health impacting event was originated. Examples are Lifecycle, Downtime, Fault Analysis etc. </param>
        /// <param name="healthEventCause"> In case of an availability impacting event, it describes where the health impacting event was originated. Examples are PlatformInitiated, UserInitiated etc. </param>
        /// <param name="healthEventCategory"> In case of an availability impacting event, it describes the category of a PlatformInitiated health impacting event. Examples are Planned, Unplanned etc. </param>
        /// <param name="healthEventId"> It is a unique Id that identifies the event. </param>
        /// <param name="resolutionEta"> When the resource's availabilityState is Unavailable and the reasonType is not User Initiated, it provides the date and time for when the issue is expected to be resolved. </param>
        /// <param name="occuredOn"> Timestamp for when last change in health status occurred. </param>
        /// <param name="reasonChronicity"> Chronicity of the availability transition. </param>
        /// <param name="reportedOn"> Timestamp for when the health was last checked. </param>
        /// <param name="recentlyResolved"> An annotation describing a change in the availabilityState to Available from Unavailable with a reasonType of type Unplanned. </param>
        /// <param name="recommendedActions"> Lists actions the user can take based on the current availabilityState of the resource. </param>
        /// <param name="serviceImpactingEvents"> Lists the service impacting events that may be affecting the health of the resource. </param>
        /// <returns> A new <see cref="Models.ResourceHealthAvailabilityStatusProperties"/> instance for mocking. </returns>
        public static ResourceHealthAvailabilityStatusProperties ResourceHealthAvailabilityStatusProperties(ResourceHealthAvailabilityStateValue? availabilityState = null, string title = null, string summary = null, string detailedStatus = null, string reasonType = null, string context = null, string category = null, string articleId = null, DateTimeOffset? rootCauseAttributionOn = null, string healthEventType = null, string healthEventCause = null, string healthEventCategory = null, string healthEventId = null, DateTimeOffset? resolutionEta = null, DateTimeOffset? occuredOn = null, ReasonChronicityType? reasonChronicity = null, DateTimeOffset? reportedOn = null, ResourceHealthAvailabilityStateRecentlyResolved recentlyResolved = null, IEnumerable<ResourceHealthRecommendedAction> recommendedActions = null, IEnumerable<ServiceImpactingEvent> serviceImpactingEvents = null)
        {
            recommendedActions ??= new List<ResourceHealthRecommendedAction>();
            serviceImpactingEvents ??= new List<ServiceImpactingEvent>();

            return new ResourceHealthAvailabilityStatusProperties(
                availabilityState,
                title,
                summary,
                detailedStatus,
                reasonType,
                context,
                category,
                articleId,
                rootCauseAttributionOn,
                healthEventType,
                healthEventCause,
                healthEventCategory,
                healthEventId,
                resolutionEta,
                occuredOn,
                reasonChronicity,
                reportedOn,
                recentlyResolved,
                recommendedActions?.ToList(),
                serviceImpactingEvents?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceHealthAvailabilityStateRecentlyResolved"/>. </summary>
        /// <param name="unavailableOccuredOn"> Timestamp for when the availabilityState changed to Unavailable. </param>
        /// <param name="resolvedOn"> Timestamp when the availabilityState changes to Available. </param>
        /// <param name="unavailableSummary"> Brief description of cause of the resource becoming unavailable. </param>
        /// <returns> A new <see cref="Models.ResourceHealthAvailabilityStateRecentlyResolved"/> instance for mocking. </returns>
        public static ResourceHealthAvailabilityStateRecentlyResolved ResourceHealthAvailabilityStateRecentlyResolved(DateTimeOffset? unavailableOccuredOn = null, DateTimeOffset? resolvedOn = null, string unavailableSummary = null)
        {
            return new ResourceHealthAvailabilityStateRecentlyResolved(unavailableOccuredOn, resolvedOn, unavailableSummary, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceHealthRecommendedAction"/>. </summary>
        /// <param name="action"> Recommended action. </param>
        /// <param name="actionUri"> Link to the action. </param>
        /// <param name="actionUriComment"> the comment for the Action. </param>
        /// <param name="actionUriText"> Substring of action, it describes which text should host the action URL. </param>
        /// <returns> A new <see cref="Models.ResourceHealthRecommendedAction"/> instance for mocking. </returns>
        public static ResourceHealthRecommendedAction ResourceHealthRecommendedAction(string action = null, Uri actionUri = null, string actionUriComment = null, string actionUriText = null)
        {
            return new ResourceHealthRecommendedAction(action, actionUri, actionUriComment, actionUriText, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServiceImpactingEvent"/>. </summary>
        /// <param name="eventStartOn"> Timestamp for when the event started. </param>
        /// <param name="eventStatusLastModifiedOn"> Timestamp for when event was submitted/detected. </param>
        /// <param name="correlationId"> Correlation id for the event. </param>
        /// <param name="statusValue"> Status of the service impacting event. </param>
        /// <param name="incidentProperties"> Properties of the service impacting event. </param>
        /// <returns> A new <see cref="Models.ServiceImpactingEvent"/> instance for mocking. </returns>
        public static ServiceImpactingEvent ServiceImpactingEvent(DateTimeOffset? eventStartOn = null, DateTimeOffset? eventStatusLastModifiedOn = null, string correlationId = null, string statusValue = null, ServiceImpactingEventIncidentProperties incidentProperties = null)
        {
            return new ServiceImpactingEvent(
                eventStartOn,
                eventStatusLastModifiedOn,
                correlationId,
                statusValue != null ? new ServiceImpactingEventStatus(statusValue, serializedAdditionalRawData: null) : null,
                incidentProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServiceImpactingEventIncidentProperties"/>. </summary>
        /// <param name="title"> Title of the incident. </param>
        /// <param name="service"> Service impacted by the event. </param>
        /// <param name="region"> Region impacted by the event. </param>
        /// <param name="incidentType"> Type of Event. </param>
        /// <returns> A new <see cref="Models.ServiceImpactingEventIncidentProperties"/> instance for mocking. </returns>
        public static ServiceImpactingEventIncidentProperties ServiceImpactingEventIncidentProperties(string title = null, string service = null, string region = null, string incidentType = null)
        {
            return new ServiceImpactingEventIncidentProperties(title, service, region, incidentType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ResourceHealth.ResourceHealthMetadataEntityData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="displayName"> The display name. </param>
        /// <param name="dependsOn"> The list of keys on which this entity depends on. </param>
        /// <param name="applicableScenarios"> The list of scenarios applicable to this metadata entity. </param>
        /// <param name="supportedValues"> The list of supported values. </param>
        /// <returns> A new <see cref="ResourceHealth.ResourceHealthMetadataEntityData"/> instance for mocking. </returns>
        public static ResourceHealthMetadataEntityData ResourceHealthMetadataEntityData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string displayName = null, IEnumerable<string> dependsOn = null, IEnumerable<MetadataEntityScenario> applicableScenarios = null, IEnumerable<MetadataSupportedValueDetail> supportedValues = null)
        {
            dependsOn ??= new List<string>();
            applicableScenarios ??= new List<MetadataEntityScenario>();
            supportedValues ??= new List<MetadataSupportedValueDetail>();

            return new ResourceHealthMetadataEntityData(
                id,
                name,
                resourceType,
                systemData,
                displayName,
                dependsOn?.ToList(),
                applicableScenarios?.ToList(),
                supportedValues?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MetadataSupportedValueDetail"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="displayName"> The display name. </param>
        /// <param name="resourceTypes"> The list of associated resource types. </param>
        /// <returns> A new <see cref="Models.MetadataSupportedValueDetail"/> instance for mocking. </returns>
        public static MetadataSupportedValueDetail MetadataSupportedValueDetail(string id = null, string displayName = null, IEnumerable<ResourceType> resourceTypes = null)
        {
            resourceTypes ??= new List<ResourceType>();

            return new MetadataSupportedValueDetail(id, displayName, resourceTypes?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ResourceHealth.ResourceHealthEventImpactedResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="targetResourceType"> Resource type within Microsoft cloud. </param>
        /// <param name="targetResourceId"> Identity for resource within Microsoft cloud. </param>
        /// <param name="targetRegion"> Impacted resource region name. </param>
        /// <param name="resourceName"> Resource name of the impacted resource. </param>
        /// <param name="resourceGroup"> Resource group name of the impacted resource. </param>
        /// <param name="status"> Status of the impacted resource. </param>
        /// <param name="maintenanceStartTime"> Start time of maintenance for the impacted resource. </param>
        /// <param name="maintenanceEndTime"> End time of maintenance for the impacted resource. </param>
        /// <param name="info"> Additional information. </param>
        /// <returns> A new <see cref="ResourceHealth.ResourceHealthEventImpactedResourceData"/> instance for mocking. </returns>
        public static ResourceHealthEventImpactedResourceData ResourceHealthEventImpactedResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceType? targetResourceType = null, ResourceIdentifier targetResourceId = null, string targetRegion = null, string resourceName = null, string resourceGroup = null, string status = null, string maintenanceStartTime = null, string maintenanceEndTime = null, IEnumerable<ResourceHealthKeyValueItem> info = null)
        {
            info ??= new List<ResourceHealthKeyValueItem>();

            return new ResourceHealthEventImpactedResourceData(
                id,
                name,
                resourceType,
                systemData,
                targetResourceType,
                targetResourceId,
                targetRegion,
                resourceName,
                resourceGroup,
                status,
                maintenanceStartTime,
                maintenanceEndTime,
                info?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceHealthKeyValueItem"/>. </summary>
        /// <param name="key"> Key of tuple. </param>
        /// <param name="value"> Value of tuple. </param>
        /// <returns> A new <see cref="Models.ResourceHealthKeyValueItem"/> instance for mocking. </returns>
        public static ResourceHealthKeyValueItem ResourceHealthKeyValueItem(string key = null, string value = null)
        {
            return new ResourceHealthKeyValueItem(key, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ResourceHealth.ResourceHealthEventData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="eventType"> Type of event. </param>
        /// <param name="eventSubType"> Sub type of the event. Currently used to determine retirement communications for health advisory events. </param>
        /// <param name="eventSource"> Source of event. </param>
        /// <param name="status"> Current status of event. </param>
        /// <param name="title"> Title text of event. </param>
        /// <param name="summary"> Summary text of event. </param>
        /// <param name="header"> Header text of event. </param>
        /// <param name="level"> Level of insight. </param>
        /// <param name="eventLevel"> Level of event. </param>
        /// <param name="externalIncidentId"> The id of the Incident. </param>
        /// <param name="reason"> The reason for the Incident. </param>
        /// <param name="article"> Article of event. </param>
        /// <param name="links"> Useful links of event. </param>
        /// <param name="impactStartOn"> It provides the Timestamp for when the health impacting event started. </param>
        /// <param name="impactMitigationOn"> It provides the Timestamp for when the health impacting event resolved. </param>
        /// <param name="impact"> List services impacted by the service health event. </param>
        /// <param name="recommendedActions"> Recommended actions of event. </param>
        /// <param name="faqs"> Frequently asked questions for the service health event. </param>
        /// <param name="isHirEvent"> It provides information if the event is High incident rate event or not. </param>
        /// <param name="isMicrosoftSupportEnabled"> Tells if we want to enable or disable Microsoft Support for this event. </param>
        /// <param name="description"> Contains the communication message for the event, that could include summary, root cause and other details. </param>
        /// <param name="isPlatformInitiated"> Is true if the event is platform initiated. </param>
        /// <param name="isChatWithUsEnabled"> Tells if we want to enable or disable Microsoft Support for this event. </param>
        /// <param name="priority"> Priority level of the event. Has value from 0 to 23. 0 is the highest priority. Service issue events have higher priority followed by planned maintenance and health advisory. Critical events have higher priority followed by error, warning and informational. Furthermore, active events have higher priority than resolved. </param>
        /// <param name="lastUpdateOn"> It provides the Timestamp for when the health impacting event was last updated. </param>
        /// <param name="hirStage"> Stage for HIR Document. </param>
        /// <param name="additionalInformationMessage"> Additional information. </param>
        /// <param name="duration"> duration in seconds. </param>
        /// <param name="impactType"> The type of the impact. </param>
        /// <param name="maintenanceId"> Unique identifier for planned maintenance event. </param>
        /// <param name="maintenanceType"> The type of planned maintenance event. </param>
        /// <param name="argQuery"> Azure Resource Graph query to fetch the affected resources from their existing Azure Resource Graph locations. </param>
        /// <returns> A new <see cref="ResourceHealth.ResourceHealthEventData"/> instance for mocking. </returns>
        public static ResourceHealthEventData ResourceHealthEventData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceHealthEventTypeValue? eventType = null, EventSubTypeValue? eventSubType = null, ResourceHealthEventSourceValue? eventSource = null, ResourceHealthEventStatusValue? status = null, string title = null, string summary = null, string header = null, ResourceHealthEventInsightLevelValue? level = null, ResourceHealthEventLevelValue? eventLevel = null, string externalIncidentId = null, string reason = null, ResourceHealthEventArticle article = null, IEnumerable<ResourceHealthEventLink> links = null, DateTimeOffset? impactStartOn = null, DateTimeOffset? impactMitigationOn = null, IEnumerable<ResourceHealthEventImpact> impact = null, ResourceHealthEventRecommendedActions recommendedActions = null, IEnumerable<ResourceHealthEventFaq> faqs = null, bool? isHirEvent = null, bool? isMicrosoftSupportEnabled = null, string description = null, bool? isPlatformInitiated = null, bool? isChatWithUsEnabled = null, int? priority = null, DateTimeOffset? lastUpdateOn = null, string hirStage = null, string additionalInformationMessage = null, int? duration = null, string impactType = null, string maintenanceId = null, string maintenanceType = null, string argQuery = null)
        {
            links ??= new List<ResourceHealthEventLink>();
            impact ??= new List<ResourceHealthEventImpact>();
            faqs ??= new List<ResourceHealthEventFaq>();

            return new ResourceHealthEventData(
                id,
                name,
                resourceType,
                systemData,
                eventType,
                eventSubType,
                eventSource,
                status,
                title,
                summary,
                header,
                level,
                eventLevel,
                externalIncidentId,
                reason,
                article,
                links?.ToList(),
                impactStartOn,
                impactMitigationOn,
                impact?.ToList(),
                recommendedActions,
                faqs?.ToList(),
                isHirEvent,
                isMicrosoftSupportEnabled,
                description,
                isPlatformInitiated,
                isChatWithUsEnabled,
                priority,
                lastUpdateOn,
                hirStage,
                additionalInformationMessage != null ? new ResourceHealthEventAdditionalInformation(additionalInformationMessage, serializedAdditionalRawData: null) : null,
                duration,
                impactType,
                maintenanceId,
                maintenanceType,
                argQuery,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceHealthEventArticle"/>. </summary>
        /// <param name="articleContent"> Article content of event. </param>
        /// <param name="articleId"> Article Id. </param>
        /// <param name="parameters"> It provides a map of parameter name and value. </param>
        /// <returns> A new <see cref="Models.ResourceHealthEventArticle"/> instance for mocking. </returns>
        public static ResourceHealthEventArticle ResourceHealthEventArticle(string articleContent = null, string articleId = null, BinaryData parameters = null)
        {
            return new ResourceHealthEventArticle(articleContent, articleId, parameters, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceHealthEventLink"/>. </summary>
        /// <param name="linkType"> Type of link. </param>
        /// <param name="displayText"> Display text of link. </param>
        /// <param name="extensionName"> It provides the name of portal extension to produce link for given service health event. </param>
        /// <param name="bladeName"> It provides the name of portal extension blade to produce link for given service health event. </param>
        /// <param name="parameters"> It provides a map of parameter name and value for portal extension blade to produce lik for given service health event. </param>
        /// <returns> A new <see cref="Models.ResourceHealthEventLink"/> instance for mocking. </returns>
        public static ResourceHealthEventLink ResourceHealthEventLink(ResourceHealthEventLinkTypeValue? linkType = null, ResourceHealthEventLinkDisplayText displayText = null, string extensionName = null, string bladeName = null, BinaryData parameters = null)
        {
            return new ResourceHealthEventLink(
                linkType,
                displayText,
                extensionName,
                bladeName,
                parameters,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceHealthEventLinkDisplayText"/>. </summary>
        /// <param name="value"> Display text of link. </param>
        /// <param name="localizedValue"> Localized display text of link. </param>
        /// <returns> A new <see cref="Models.ResourceHealthEventLinkDisplayText"/> instance for mocking. </returns>
        public static ResourceHealthEventLinkDisplayText ResourceHealthEventLinkDisplayText(string value = null, string localizedValue = null)
        {
            return new ResourceHealthEventLinkDisplayText(value, localizedValue, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceHealthEventImpact"/>. </summary>
        /// <param name="impactedService"> Impacted service name. </param>
        /// <param name="impactedRegions"> List regions impacted by the service health event. </param>
        /// <returns> A new <see cref="Models.ResourceHealthEventImpact"/> instance for mocking. </returns>
        public static ResourceHealthEventImpact ResourceHealthEventImpact(string impactedService = null, IEnumerable<ResourceHealthEventImpactedServiceRegion> impactedRegions = null)
        {
            impactedRegions ??= new List<ResourceHealthEventImpactedServiceRegion>();

            return new ResourceHealthEventImpact(impactedService, impactedRegions?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceHealthEventImpactedServiceRegion"/>. </summary>
        /// <param name="impactedRegion"> Impacted region name. </param>
        /// <param name="status"> Current status of event in the region. </param>
        /// <param name="impactedSubscriptions"> List subscription impacted by the service health event. </param>
        /// <param name="impactedTenants"> List tenant impacted by the service health event. </param>
        /// <param name="lastUpdateOn"> It provides the Timestamp for when the last update for the service health event. </param>
        /// <param name="updates"> List of updates for given service health event. </param>
        /// <returns> A new <see cref="Models.ResourceHealthEventImpactedServiceRegion"/> instance for mocking. </returns>
        public static ResourceHealthEventImpactedServiceRegion ResourceHealthEventImpactedServiceRegion(string impactedRegion = null, ResourceHealthEventStatusValue? status = null, IEnumerable<string> impactedSubscriptions = null, IEnumerable<string> impactedTenants = null, DateTimeOffset? lastUpdateOn = null, IEnumerable<ResourceHealthEventUpdate> updates = null)
        {
            impactedSubscriptions ??= new List<string>();
            impactedTenants ??= new List<string>();
            updates ??= new List<ResourceHealthEventUpdate>();

            return new ResourceHealthEventImpactedServiceRegion(
                impactedRegion,
                status,
                impactedSubscriptions?.ToList(),
                impactedTenants?.ToList(),
                lastUpdateOn,
                updates?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceHealthEventUpdate"/>. </summary>
        /// <param name="summary"> Summary text for the given update for the service health event. </param>
        /// <param name="updatedOn"> It provides the Timestamp for the given update for the service health event. </param>
        /// <returns> A new <see cref="Models.ResourceHealthEventUpdate"/> instance for mocking. </returns>
        public static ResourceHealthEventUpdate ResourceHealthEventUpdate(string summary = null, DateTimeOffset? updatedOn = null)
        {
            return new ResourceHealthEventUpdate(summary, updatedOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceHealthEventRecommendedActions"/>. </summary>
        /// <param name="message"> Recommended action title for the service health event. </param>
        /// <param name="actions"> Recommended actions for the service health event. </param>
        /// <param name="localeCode"> Recommended action locale for the service health event. </param>
        /// <returns> A new <see cref="Models.ResourceHealthEventRecommendedActions"/> instance for mocking. </returns>
        public static ResourceHealthEventRecommendedActions ResourceHealthEventRecommendedActions(string message = null, IEnumerable<ResourceHealthEventRecommendedActionsItem> actions = null, string localeCode = null)
        {
            actions ??= new List<ResourceHealthEventRecommendedActionsItem>();

            return new ResourceHealthEventRecommendedActions(message, actions?.ToList(), localeCode, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceHealthEventRecommendedActionsItem"/>. </summary>
        /// <param name="groupId"> Recommended action group Id for the service health event. </param>
        /// <param name="actionText"> Recommended action text. </param>
        /// <returns> A new <see cref="Models.ResourceHealthEventRecommendedActionsItem"/> instance for mocking. </returns>
        public static ResourceHealthEventRecommendedActionsItem ResourceHealthEventRecommendedActionsItem(int? groupId = null, string actionText = null)
        {
            return new ResourceHealthEventRecommendedActionsItem(groupId, actionText, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceHealthEventFaq"/>. </summary>
        /// <param name="question"> FAQ question for the service health event. </param>
        /// <param name="answer"> FAQ answer for the service health event. </param>
        /// <param name="localeCode"> FAQ locale for the service health event. </param>
        /// <returns> A new <see cref="Models.ResourceHealthEventFaq"/> instance for mocking. </returns>
        public static ResourceHealthEventFaq ResourceHealthEventFaq(string question = null, string answer = null, string localeCode = null)
        {
            return new ResourceHealthEventFaq(question, answer, localeCode, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ResourceHealth.ServiceEmergingIssueData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="refreshedOn"> Timestamp for when last time refreshed for ongoing emerging issue. </param>
        /// <param name="statusBanners"> The list of emerging issues of banner type. </param>
        /// <param name="statusActiveEvents"> The list of emerging issues of active event type. </param>
        /// <returns> A new <see cref="ResourceHealth.ServiceEmergingIssueData"/> instance for mocking. </returns>
        public static ServiceEmergingIssueData ServiceEmergingIssueData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? refreshedOn = null, IEnumerable<EmergingIssueBannerType> statusBanners = null, IEnumerable<EmergingIssueActiveEventType> statusActiveEvents = null)
        {
            statusBanners ??= new List<EmergingIssueBannerType>();
            statusActiveEvents ??= new List<EmergingIssueActiveEventType>();

            return new ServiceEmergingIssueData(
                id,
                name,
                resourceType,
                systemData,
                refreshedOn,
                statusBanners?.ToList(),
                statusActiveEvents?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EmergingIssueBannerType"/>. </summary>
        /// <param name="title"> The banner title. </param>
        /// <param name="message"> The details of banner. </param>
        /// <param name="cloud"> The cloud type of this banner. </param>
        /// <param name="lastModifiedOn"> The last time modified on this banner. </param>
        /// <returns> A new <see cref="Models.EmergingIssueBannerType"/> instance for mocking. </returns>
        public static EmergingIssueBannerType EmergingIssueBannerType(string title = null, string message = null, string cloud = null, DateTimeOffset? lastModifiedOn = null)
        {
            return new EmergingIssueBannerType(title, message, cloud, lastModifiedOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EmergingIssueActiveEventType"/>. </summary>
        /// <param name="title"> The active event title. </param>
        /// <param name="description"> The details of active event. </param>
        /// <param name="trackingId"> The tracking id of this active event. </param>
        /// <param name="startOn"> The impact start time on this active event. </param>
        /// <param name="cloud"> The cloud type of this active event. </param>
        /// <param name="severity"> The severity level of this active event. </param>
        /// <param name="stage"> The stage of this active event. </param>
        /// <param name="isPublished"> The boolean value of this active event if published or not. </param>
        /// <param name="lastModifiedOn"> The last time modified on this banner. </param>
        /// <param name="impacts"> The list of emerging issues impacts. </param>
        /// <returns> A new <see cref="Models.EmergingIssueActiveEventType"/> instance for mocking. </returns>
        public static EmergingIssueActiveEventType EmergingIssueActiveEventType(string title = null, string description = null, string trackingId = null, DateTimeOffset? startOn = null, string cloud = null, ResourceHealthEventSeverityLevel? severity = null, ResourceHealthEventStageValue? stage = null, bool? isPublished = null, DateTimeOffset? lastModifiedOn = null, IEnumerable<EmergingIssueImpact> impacts = null)
        {
            impacts ??= new List<EmergingIssueImpact>();

            return new EmergingIssueActiveEventType(
                title,
                description,
                trackingId,
                startOn,
                cloud,
                severity,
                stage,
                isPublished,
                lastModifiedOn,
                impacts?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EmergingIssueImpact"/>. </summary>
        /// <param name="id"> The impacted service id. </param>
        /// <param name="name"> The impacted service name. </param>
        /// <param name="regions"> The list of impacted regions for corresponding emerging issues. </param>
        /// <returns> A new <see cref="Models.EmergingIssueImpact"/> instance for mocking. </returns>
        public static EmergingIssueImpact EmergingIssueImpact(string id = null, string name = null, IEnumerable<EmergingIssueImpactedRegion> regions = null)
        {
            regions ??= new List<EmergingIssueImpactedRegion>();

            return new EmergingIssueImpact(id, name, regions?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EmergingIssueImpactedRegion"/>. </summary>
        /// <param name="id"> The impacted region id. </param>
        /// <param name="name"> The impacted region name. </param>
        /// <returns> A new <see cref="Models.EmergingIssueImpactedRegion"/> instance for mocking. </returns>
        public static EmergingIssueImpactedRegion EmergingIssueImpactedRegion(string id = null, string name = null)
        {
            return new EmergingIssueImpactedRegion(id, name, serializedAdditionalRawData: null);
        }
    }
}
