// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ResourceHealth.Models;

namespace Azure.ResourceManager.ResourceHealth.Samples
{
    public partial class Sample_ServiceEmergingIssueResource
    {
        // GetEmergingIssues
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetEmergingIssues()
        {
            // Generated from example definition: specification/resourcehealth/resource-manager/Microsoft.ResourceHealth/preview/2023-10-01-preview/examples/EmergingIssues_Get.json
            // this example is just showing the usage of "EmergingIssues_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceEmergingIssueResource created on azure
            // for more information of creating ServiceEmergingIssueResource, please refer to the document of ServiceEmergingIssueResource
            EmergingIssueNameContent issueName = EmergingIssueNameContent.Default;
            ResourceIdentifier serviceEmergingIssueResourceId = ServiceEmergingIssueResource.CreateResourceIdentifier(issueName);
            ServiceEmergingIssueResource serviceEmergingIssue = client.GetServiceEmergingIssueResource(serviceEmergingIssueResourceId);

            // invoke the operation
            ServiceEmergingIssueResource result = await serviceEmergingIssue.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServiceEmergingIssueData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
