// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ResourceGraph.Models
{
    internal static partial class ResultFormatExtensions
    {
        public static string ToSerialString(this ResultFormat value) => value switch
        {
            ResultFormat.Table => "table",
            ResultFormat.ObjectArray => "objectArray",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ResultFormat value.")
        };

        public static ResultFormat ToResultFormat(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "table")) return ResultFormat.Table;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "objectArray")) return ResultFormat.ObjectArray;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ResultFormat value.");
        }
    }
}
