// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ResourceGraph.Models
{
    /// <summary> Successfully executed facet containing additional statistics on the response of a query. </summary>
    public partial class FacetResult : Facet
    {
        /// <summary> Initializes a new instance of <see cref="FacetResult"/>. </summary>
        /// <param name="expression"> Facet expression, same as in the corresponding facet request. </param>
        /// <param name="totalRecords"> Number of total records in the facet results. </param>
        /// <param name="count"> Number of records returned in the facet response. </param>
        /// <param name="data"> A JObject array or Table containing the desired facets. Only present if the facet is valid. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="expression"/> or <paramref name="data"/> is null. </exception>
        internal FacetResult(string expression, long totalRecords, int count, BinaryData data) : base(expression)
        {
            Argument.AssertNotNull(expression, nameof(expression));
            Argument.AssertNotNull(data, nameof(data));

            TotalRecords = totalRecords;
            Count = count;
            Data = data;
            ResultType = "FacetResult";
        }

        /// <summary> Initializes a new instance of <see cref="FacetResult"/>. </summary>
        /// <param name="expression"> Facet expression, same as in the corresponding facet request. </param>
        /// <param name="resultType"> Result type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="totalRecords"> Number of total records in the facet results. </param>
        /// <param name="count"> Number of records returned in the facet response. </param>
        /// <param name="data"> A JObject array or Table containing the desired facets. Only present if the facet is valid. </param>
        internal FacetResult(string expression, string resultType, IDictionary<string, BinaryData> serializedAdditionalRawData, long totalRecords, int count, BinaryData data) : base(expression, resultType, serializedAdditionalRawData)
        {
            TotalRecords = totalRecords;
            Count = count;
            Data = data;
            ResultType = resultType ?? "FacetResult";
        }

        /// <summary> Initializes a new instance of <see cref="FacetResult"/> for deserialization. </summary>
        internal FacetResult()
        {
        }

        /// <summary> Number of total records in the facet results. </summary>
        public long TotalRecords { get; }
        /// <summary> Number of records returned in the facet response. </summary>
        public int Count { get; }
        /// <summary>
        /// A JObject array or Table containing the desired facets. Only present if the facet is valid.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public BinaryData Data { get; }
    }
}
