// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ResourceGraph.Models
{
    /// <summary> A request to compute additional statistics (facets) over the query results. </summary>
    public partial class FacetRequest
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FacetRequest"/>. </summary>
        /// <param name="expression"> The column or list of columns to summarize by. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="expression"/> is null. </exception>
        public FacetRequest(string expression)
        {
            Argument.AssertNotNull(expression, nameof(expression));

            Expression = expression;
        }

        /// <summary> Initializes a new instance of <see cref="FacetRequest"/>. </summary>
        /// <param name="expression"> The column or list of columns to summarize by. </param>
        /// <param name="options"> The options for facet evaluation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FacetRequest(string expression, FacetRequestOptions options, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Expression = expression;
            Options = options;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FacetRequest"/> for deserialization. </summary>
        internal FacetRequest()
        {
        }

        /// <summary> The column or list of columns to summarize by. </summary>
        public string Expression { get; }
        /// <summary> The options for facet evaluation. </summary>
        public FacetRequestOptions Options { get; set; }
    }
}
