// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ResourceGraph.Models
{
    internal static partial class AuthorizationScopeFilterExtensions
    {
        public static string ToSerialString(this AuthorizationScopeFilter value) => value switch
        {
            AuthorizationScopeFilter.AtScopeAndBelow => "AtScopeAndBelow",
            AuthorizationScopeFilter.AtScopeAndAbove => "AtScopeAndAbove",
            AuthorizationScopeFilter.AtScopeExact => "AtScopeExact",
            AuthorizationScopeFilter.AtScopeAboveAndBelow => "AtScopeAboveAndBelow",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AuthorizationScopeFilter value.")
        };

        public static AuthorizationScopeFilter ToAuthorizationScopeFilter(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AtScopeAndBelow")) return AuthorizationScopeFilter.AtScopeAndBelow;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AtScopeAndAbove")) return AuthorizationScopeFilter.AtScopeAndAbove;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AtScopeExact")) return AuthorizationScopeFilter.AtScopeExact;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AtScopeAboveAndBelow")) return AuthorizationScopeFilter.AtScopeAboveAndBelow;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AuthorizationScopeFilter value.");
        }
    }
}
