// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ResourceGraph.Models;

namespace Azure.ResourceManager.ResourceGraph.Samples
{
    public partial class Sample_TenantResourceExtensions
    {
        // Access a properties field
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetResources_AccessAPropertiesField()
        {
            // Generated from example definition: specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesPropertiesQuery.json
            // this example is just showing the usage of "Resources" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            ResourceQueryContent content = new ResourceQueryContent("Resources | where type =~ 'Microsoft.Compute/virtualMachines' | summarize count() by tostring(properties.storageProfile.osDisk.osType)")
            {
                Subscriptions =
{
"cfbbd179-59d2-4052-aa06-9270a38aa9d6"
},
            };
            ResourceQueryResult result = await tenantResource.GetResourcesAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Basic management group query
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetResources_BasicManagementGroupQuery()
        {
            // Generated from example definition: specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesMgBasicQuery.json
            // this example is just showing the usage of "Resources" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            ResourceQueryContent content = new ResourceQueryContent("Resources | project id, name, type, location, tags | limit 3")
            {
                ManagementGroups =
{
"e927f598-c1d4-4f72-8541-95d83a6a4ac8","ProductionMG"
},
            };
            ResourceQueryResult result = await tenantResource.GetResourcesAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Basic query
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetResources_BasicQuery()
        {
            // Generated from example definition: specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesBasicQuery.json
            // this example is just showing the usage of "Resources" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            ResourceQueryContent content = new ResourceQueryContent("Resources | project id, name, type, location, tags | limit 3")
            {
                Subscriptions =
{
"cfbbd179-59d2-4052-aa06-9270a38aa9d6"
},
            };
            ResourceQueryResult result = await tenantResource.GetResourcesAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Basic tenant query
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetResources_BasicTenantQuery()
        {
            // Generated from example definition: specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesTenantBasicQuery.json
            // this example is just showing the usage of "Resources" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            ResourceQueryContent content = new ResourceQueryContent("Resources | project id, name, type, location, tags | limit 3");
            ResourceQueryResult result = await tenantResource.GetResourcesAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Complex query
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetResources_ComplexQuery()
        {
            // Generated from example definition: specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesComplexQuery.json
            // this example is just showing the usage of "Resources" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            ResourceQueryContent content = new ResourceQueryContent("Resources | project id, name, type, location | where type =~ 'Microsoft.Compute/virtualMachines' | summarize count() by location | top 3 by count_")
            {
                Subscriptions =
{
"cfbbd179-59d2-4052-aa06-9270a38aa9d6"
},
            };
            ResourceQueryResult result = await tenantResource.GetResourcesAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Filter resources
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetResources_FilterResources()
        {
            // Generated from example definition: specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesFilterQuery.json
            // this example is just showing the usage of "Resources" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            ResourceQueryContent content = new ResourceQueryContent("Resources | project id, name, type, location | where type =~ 'Microsoft.Compute/virtualMachines' | limit 3")
            {
                Subscriptions =
{
"cfbbd179-59d2-4052-aa06-9270a38aa9d6"
},
            };
            ResourceQueryResult result = await tenantResource.GetResourcesAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // First page query
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetResources_FirstPageQuery()
        {
            // Generated from example definition: specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesFirstPageQuery.json
            // this example is just showing the usage of "Resources" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            ResourceQueryContent content = new ResourceQueryContent("Resources | where name contains 'test' | project id, name, type, location")
            {
                Subscriptions =
{
"cfbbd179-59d2-4052-aa06-9270a38aa9d6"
},
                Options = new ResourceQueryRequestOptions()
                {
                    Top = 3,
                    Skip = 0,
                },
            };
            ResourceQueryResult result = await tenantResource.GetResourcesAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Next page query
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetResources_NextPageQuery()
        {
            // Generated from example definition: specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesNextPageQuery.json
            // this example is just showing the usage of "Resources" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            ResourceQueryContent content = new ResourceQueryContent("Resources | where name contains 'test' | project id, name, type, location")
            {
                Subscriptions =
{
"cfbbd179-59d2-4052-aa06-9270a38aa9d6"
},
                Options = new ResourceQueryRequestOptions()
                {
                    SkipToken = "eyAibm8iOiAibHVjayIsICJidXQiOiAibmljZSIsICJ0cnkiOiAiISIgfQ==",
                },
            };
            ResourceQueryResult result = await tenantResource.GetResourcesAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Query with a facet request
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetResources_QueryWithAFacetRequest()
        {
            // Generated from example definition: specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesFacetQuery.json
            // this example is just showing the usage of "Resources" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            ResourceQueryContent content = new ResourceQueryContent("Resources | where type =~ 'Microsoft.Compute/virtualMachines' | project id, name, location, resourceGroup, properties.storageProfile.osDisk.osType | limit 5")
            {
                Subscriptions =
{
"cfbbd179-59d2-4052-aa06-9270a38aa9d6"
},
                Facets =
{
new FacetRequest("location")
{
Options = new FacetRequestOptions()
{
SortOrder = FacetSortOrder.Desc,
Top = 3,
},
},new FacetRequest("properties.storageProfile.osDisk.osType")
{
Options = new FacetRequestOptions()
{
SortOrder = FacetSortOrder.Desc,
Top = 3,
},
},new FacetRequest("nonExistingColumn")
{
Options = new FacetRequestOptions()
{
SortOrder = FacetSortOrder.Desc,
Top = 3,
},
},new FacetRequest("resourceGroup")
{
Options = new FacetRequestOptions()
{
SortBy = "tolower(resourceGroup)",
SortOrder = FacetSortOrder.Asc,
Top = 3,
},
},new FacetRequest("resourceGroup")
{
Options = new FacetRequestOptions()
{
Filter = "resourceGroup contains 'test'",
Top = 3,
},
}
},
            };
            ResourceQueryResult result = await tenantResource.GetResourcesAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Random page query
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetResources_RandomPageQuery()
        {
            // Generated from example definition: specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesRandomPageQuery.json
            // this example is just showing the usage of "Resources" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            ResourceQueryContent content = new ResourceQueryContent("Resources | where name contains 'test' | project id, name, type, location")
            {
                Subscriptions =
{
"cfbbd179-59d2-4052-aa06-9270a38aa9d6"
},
                Options = new ResourceQueryRequestOptions()
                {
                    Top = 2,
                    Skip = 10,
                },
            };
            ResourceQueryResult result = await tenantResource.GetResourcesAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Summarize resources by location
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetResources_SummarizeResourcesByLocation()
        {
            // Generated from example definition: specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesSummarizeQuery.json
            // this example is just showing the usage of "Resources" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            ResourceQueryContent content = new ResourceQueryContent("Resources | project id, name, type, location | summarize by location")
            {
                Subscriptions =
{
"cfbbd179-59d2-4052-aa06-9270a38aa9d6"
},
            };
            ResourceQueryResult result = await tenantResource.GetResourcesAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Resource History Management Group scope Query
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetResourceHistory_ResourceHistoryManagementGroupScopeQuery()
        {
            // Generated from example definition: specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesHistoryMgsGet.json
            // this example is just showing the usage of "ResourcesHistory" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            ResourcesHistoryContent content = new ResourcesHistoryContent()
            {
                Query = "where name =~ 'cpu-utilization' | project id, name, properties",
                Options = new ResourcesHistoryRequestOptions()
                {
                    Interval = new DateTimeInterval(DateTimeOffset.Parse("2020-11-12T01:00:00.0000000Z"), DateTimeOffset.Parse("2020-11-12T01:25:00.0000000Z")),
                },
                ManagementGroups =
{
"e927f598-c1d4-4f72-8541-95d83a6a4ac8","ProductionMG"
},
            };
            BinaryData result = await tenantResource.GetResourceHistoryAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Resource History Query
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetResourceHistory_ResourceHistoryQuery()
        {
            // Generated from example definition: specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesHistoryGet.json
            // this example is just showing the usage of "ResourcesHistory" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            ResourcesHistoryContent content = new ResourcesHistoryContent()
            {
                Subscriptions =
{
"a7f33fdb-e646-4f15-89aa-3a360210861e"
},
                Query = "where name =~ 'cpu-utilization' | project id, name, properties",
                Options = new ResourcesHistoryRequestOptions()
                {
                    Interval = new DateTimeInterval(DateTimeOffset.Parse("2020-11-12T01:00:00.0000000Z"), DateTimeOffset.Parse("2020-11-12T01:25:00.0000000Z")),
                },
            };
            BinaryData result = await tenantResource.GetResourceHistoryAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
