// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.ResourceConnector.Models;

namespace Azure.ResourceManager.ResourceConnector
{
    /// <summary>
    /// A class representing the ResourceConnectorAppliance data model.
    /// Appliances definition.
    /// </summary>
    public partial class ResourceConnectorApplianceData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceConnectorApplianceData"/>. </summary>
        /// <param name="location"> The location. </param>
        public ResourceConnectorApplianceData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="ResourceConnectorApplianceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Identity for the resource. Current supported identity types: SystemAssigned, None. </param>
        /// <param name="distro"> Represents a supported Fabric/Infra. (AKSEdge etc...). </param>
        /// <param name="infrastructureConfig"> Contains infrastructure information about the Appliance. </param>
        /// <param name="provisioningState"> The current deployment or provisioning state, which only appears in the response. </param>
        /// <param name="publicKey"> Certificates pair used to download MSI certificate from HIS. Can only be set once. </param>
        /// <param name="status"> Appliance’s health and state of connection to on-prem. </param>
        /// <param name="version"> Version of the Appliance. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceConnectorApplianceData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ManagedServiceIdentity identity, ResourceConnectorDistro? distro, AppliancePropertiesInfrastructureConfig infrastructureConfig, string provisioningState, string publicKey, ResourceConnectorStatus? status, string version, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Identity = identity;
            Distro = distro;
            InfrastructureConfig = infrastructureConfig;
            ProvisioningState = provisioningState;
            PublicKey = publicKey;
            Status = status;
            Version = version;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ResourceConnectorApplianceData"/> for deserialization. </summary>
        internal ResourceConnectorApplianceData()
        {
        }

        /// <summary> Identity for the resource. Current supported identity types: SystemAssigned, None. </summary>
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> Represents a supported Fabric/Infra. (AKSEdge etc...). </summary>
        public ResourceConnectorDistro? Distro { get; set; }
        /// <summary> Contains infrastructure information about the Appliance. </summary>
        internal AppliancePropertiesInfrastructureConfig InfrastructureConfig { get; set; }
        /// <summary> Information about the connected appliance. </summary>
        public ApplianceProvider? InfrastructureConfigProvider
        {
            get => InfrastructureConfig is null ? default : InfrastructureConfig.Provider;
            set
            {
                if (InfrastructureConfig is null)
                    InfrastructureConfig = new AppliancePropertiesInfrastructureConfig();
                InfrastructureConfig.Provider = value;
            }
        }

        /// <summary> The current deployment or provisioning state, which only appears in the response. </summary>
        public string ProvisioningState { get; }
        /// <summary> Certificates pair used to download MSI certificate from HIS. Can only be set once. </summary>
        public string PublicKey { get; set; }
        /// <summary> Appliance’s health and state of connection to on-prem. </summary>
        public ResourceConnectorStatus? Status { get; }
        /// <summary> Version of the Appliance. </summary>
        public string Version { get; set; }
    }
}
