// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ResourceConnector.Models
{
    /// <summary> Appliance’s health and state of connection to on-prem. </summary>
    public readonly partial struct ResourceConnectorStatus : IEquatable<ResourceConnectorStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceConnectorStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceConnectorStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WaitingForHeartbeatValue = "WaitingForHeartbeat";
        private const string ValidatingValue = "Validating";
        private const string ConnectingValue = "Connecting";
        private const string ConnectedValue = "Connected";
        private const string RunningValue = "Running";
        private const string PreparingForUpgradeValue = "PreparingForUpgrade";
        private const string EtcdSnapshotFailedValue = "ETCDSnapshotFailed";
        private const string UpgradePrerequisitesCompletedValue = "UpgradePrerequisitesCompleted";
        private const string ValidatingSFSConnectivityValue = "ValidatingSFSConnectivity";
        private const string ValidatingImageDownloadValue = "ValidatingImageDownload";
        private const string ValidatingImageUploadValue = "ValidatingImageUpload";
        private const string ValidatingEtcdHealthValue = "ValidatingETCDHealth";
        private const string PreUpgradeValue = "PreUpgrade";
        private const string UpgradingKvaioValue = "UpgradingKVAIO";
        private const string WaitingForKvaioValue = "WaitingForKVAIO";
        private const string ImagePendingValue = "ImagePending";
        private const string ImageProvisioningValue = "ImageProvisioning";
        private const string ImageProvisionedValue = "ImageProvisioned";
        private const string ImageDownloadingValue = "ImageDownloading";
        private const string ImageDownloadedValue = "ImageDownloaded";
        private const string ImageDeprovisioningValue = "ImageDeprovisioning";
        private const string ImageUnknownValue = "ImageUnknown";
        private const string UpdatingCloudOperatorValue = "UpdatingCloudOperator";
        private const string WaitingForCloudOperatorValue = "WaitingForCloudOperator";
        private const string UpdatingCapiValue = "UpdatingCAPI";
        private const string UpdatingClusterValue = "UpdatingCluster";
        private const string PostUpgradeValue = "PostUpgrade";
        private const string UpgradeCompleteValue = "UpgradeComplete";
        private const string UpgradeClusterExtensionFailedToDeleteValue = "UpgradeClusterExtensionFailedToDelete";
        private const string UpgradeFailedValue = "UpgradeFailed";
        private const string OfflineValue = "Offline";
        private const string NoneValue = "None";

        /// <summary> WaitingForHeartbeat. </summary>
        public static ResourceConnectorStatus WaitingForHeartbeat { get; } = new ResourceConnectorStatus(WaitingForHeartbeatValue);
        /// <summary> Validating. </summary>
        public static ResourceConnectorStatus Validating { get; } = new ResourceConnectorStatus(ValidatingValue);
        /// <summary> Connecting. </summary>
        public static ResourceConnectorStatus Connecting { get; } = new ResourceConnectorStatus(ConnectingValue);
        /// <summary> Connected. </summary>
        public static ResourceConnectorStatus Connected { get; } = new ResourceConnectorStatus(ConnectedValue);
        /// <summary> Running. </summary>
        public static ResourceConnectorStatus Running { get; } = new ResourceConnectorStatus(RunningValue);
        /// <summary> PreparingForUpgrade. </summary>
        public static ResourceConnectorStatus PreparingForUpgrade { get; } = new ResourceConnectorStatus(PreparingForUpgradeValue);
        /// <summary> ETCDSnapshotFailed. </summary>
        public static ResourceConnectorStatus EtcdSnapshotFailed { get; } = new ResourceConnectorStatus(EtcdSnapshotFailedValue);
        /// <summary> UpgradePrerequisitesCompleted. </summary>
        public static ResourceConnectorStatus UpgradePrerequisitesCompleted { get; } = new ResourceConnectorStatus(UpgradePrerequisitesCompletedValue);
        /// <summary> ValidatingSFSConnectivity. </summary>
        public static ResourceConnectorStatus ValidatingSFSConnectivity { get; } = new ResourceConnectorStatus(ValidatingSFSConnectivityValue);
        /// <summary> ValidatingImageDownload. </summary>
        public static ResourceConnectorStatus ValidatingImageDownload { get; } = new ResourceConnectorStatus(ValidatingImageDownloadValue);
        /// <summary> ValidatingImageUpload. </summary>
        public static ResourceConnectorStatus ValidatingImageUpload { get; } = new ResourceConnectorStatus(ValidatingImageUploadValue);
        /// <summary> ValidatingETCDHealth. </summary>
        public static ResourceConnectorStatus ValidatingEtcdHealth { get; } = new ResourceConnectorStatus(ValidatingEtcdHealthValue);
        /// <summary> PreUpgrade. </summary>
        public static ResourceConnectorStatus PreUpgrade { get; } = new ResourceConnectorStatus(PreUpgradeValue);
        /// <summary> UpgradingKVAIO. </summary>
        public static ResourceConnectorStatus UpgradingKvaio { get; } = new ResourceConnectorStatus(UpgradingKvaioValue);
        /// <summary> WaitingForKVAIO. </summary>
        public static ResourceConnectorStatus WaitingForKvaio { get; } = new ResourceConnectorStatus(WaitingForKvaioValue);
        /// <summary> ImagePending. </summary>
        public static ResourceConnectorStatus ImagePending { get; } = new ResourceConnectorStatus(ImagePendingValue);
        /// <summary> ImageProvisioning. </summary>
        public static ResourceConnectorStatus ImageProvisioning { get; } = new ResourceConnectorStatus(ImageProvisioningValue);
        /// <summary> ImageProvisioned. </summary>
        public static ResourceConnectorStatus ImageProvisioned { get; } = new ResourceConnectorStatus(ImageProvisionedValue);
        /// <summary> ImageDownloading. </summary>
        public static ResourceConnectorStatus ImageDownloading { get; } = new ResourceConnectorStatus(ImageDownloadingValue);
        /// <summary> ImageDownloaded. </summary>
        public static ResourceConnectorStatus ImageDownloaded { get; } = new ResourceConnectorStatus(ImageDownloadedValue);
        /// <summary> ImageDeprovisioning. </summary>
        public static ResourceConnectorStatus ImageDeprovisioning { get; } = new ResourceConnectorStatus(ImageDeprovisioningValue);
        /// <summary> ImageUnknown. </summary>
        public static ResourceConnectorStatus ImageUnknown { get; } = new ResourceConnectorStatus(ImageUnknownValue);
        /// <summary> UpdatingCloudOperator. </summary>
        public static ResourceConnectorStatus UpdatingCloudOperator { get; } = new ResourceConnectorStatus(UpdatingCloudOperatorValue);
        /// <summary> WaitingForCloudOperator. </summary>
        public static ResourceConnectorStatus WaitingForCloudOperator { get; } = new ResourceConnectorStatus(WaitingForCloudOperatorValue);
        /// <summary> UpdatingCAPI. </summary>
        public static ResourceConnectorStatus UpdatingCapi { get; } = new ResourceConnectorStatus(UpdatingCapiValue);
        /// <summary> UpdatingCluster. </summary>
        public static ResourceConnectorStatus UpdatingCluster { get; } = new ResourceConnectorStatus(UpdatingClusterValue);
        /// <summary> PostUpgrade. </summary>
        public static ResourceConnectorStatus PostUpgrade { get; } = new ResourceConnectorStatus(PostUpgradeValue);
        /// <summary> UpgradeComplete. </summary>
        public static ResourceConnectorStatus UpgradeComplete { get; } = new ResourceConnectorStatus(UpgradeCompleteValue);
        /// <summary> UpgradeClusterExtensionFailedToDelete. </summary>
        public static ResourceConnectorStatus UpgradeClusterExtensionFailedToDelete { get; } = new ResourceConnectorStatus(UpgradeClusterExtensionFailedToDeleteValue);
        /// <summary> UpgradeFailed. </summary>
        public static ResourceConnectorStatus UpgradeFailed { get; } = new ResourceConnectorStatus(UpgradeFailedValue);
        /// <summary> Offline. </summary>
        public static ResourceConnectorStatus Offline { get; } = new ResourceConnectorStatus(OfflineValue);
        /// <summary> None. </summary>
        public static ResourceConnectorStatus None { get; } = new ResourceConnectorStatus(NoneValue);
        /// <summary> Determines if two <see cref="ResourceConnectorStatus"/> values are the same. </summary>
        public static bool operator ==(ResourceConnectorStatus left, ResourceConnectorStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceConnectorStatus"/> values are not the same. </summary>
        public static bool operator !=(ResourceConnectorStatus left, ResourceConnectorStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceConnectorStatus"/>. </summary>
        public static implicit operator ResourceConnectorStatus(string value) => new ResourceConnectorStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceConnectorStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceConnectorStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
