// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ResourceConnector.Models
{
    public partial class ApplianceUpgradeGraphProperties : IUtf8JsonSerializable, IJsonModel<ApplianceUpgradeGraphProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ApplianceUpgradeGraphProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ApplianceUpgradeGraphProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplianceUpgradeGraphProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ApplianceUpgradeGraphProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ApplianceVersion))
            {
                writer.WritePropertyName("applianceVersion"u8);
                writer.WriteStringValue(ApplianceVersion);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(SupportedVersions))
            {
                writer.WritePropertyName("supportedVersions"u8);
                writer.WriteStartArray();
                foreach (var item in SupportedVersions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ApplianceUpgradeGraphProperties IJsonModel<ApplianceUpgradeGraphProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplianceUpgradeGraphProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ApplianceUpgradeGraphProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeApplianceUpgradeGraphProperties(document.RootElement, options);
        }

        internal static ApplianceUpgradeGraphProperties DeserializeApplianceUpgradeGraphProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string applianceVersion = default;
            IReadOnlyList<ApplianceSupportedVersion> supportedVersions = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("applianceVersion"u8))
                {
                    applianceVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("supportedVersions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ApplianceSupportedVersion> array = new List<ApplianceSupportedVersion>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ApplianceSupportedVersion.DeserializeApplianceSupportedVersion(item, options));
                    }
                    supportedVersions = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ApplianceUpgradeGraphProperties(applianceVersion, supportedVersions ?? new ChangeTrackingList<ApplianceSupportedVersion>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ApplianceUpgradeGraphProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplianceUpgradeGraphProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ApplianceUpgradeGraphProperties)} does not support writing '{options.Format}' format.");
            }
        }

        ApplianceUpgradeGraphProperties IPersistableModel<ApplianceUpgradeGraphProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplianceUpgradeGraphProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeApplianceUpgradeGraphProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ApplianceUpgradeGraphProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ApplianceUpgradeGraphProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
