// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ResourceConnector.Models
{
    /// <summary> The SupportedVersionMetadata object for appliance. </summary>
    internal partial class ApplianceSupportedVersionMetadata
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApplianceSupportedVersionMetadata"/>. </summary>
        internal ApplianceSupportedVersionMetadata()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ApplianceSupportedVersionMetadata"/>. </summary>
        /// <param name="catalogVersion"> The newer supported version catalog version. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApplianceSupportedVersionMetadata(ApplianceSupportedVersionCatalogVersion catalogVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CatalogVersion = catalogVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The newer supported version catalog version. </summary>
        public ApplianceSupportedVersionCatalogVersion CatalogVersion { get; }
    }
}
