// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ResourceConnector.Models
{
    /// <summary> The SupportedVersionCatalogVersion object for appliance. </summary>
    public partial class ApplianceSupportedVersionCatalogVersion
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApplianceSupportedVersionCatalogVersion"/>. </summary>
        internal ApplianceSupportedVersionCatalogVersion()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ApplianceSupportedVersionCatalogVersion"/>. </summary>
        /// <param name="data"> The newer supported version catalog version data. </param>
        /// <param name="name"> The catalog version name for the version available for upgrade. </param>
        /// <param name="namespace"> The catalog version namespace for the version available for upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApplianceSupportedVersionCatalogVersion(ApplianceSupportedVersionCatalogVersionProperties data, string name, string @namespace, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Data = data;
            Name = name;
            Namespace = @namespace;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The newer supported version catalog version data. </summary>
        public ApplianceSupportedVersionCatalogVersionProperties Data { get; }
        /// <summary> The catalog version name for the version available for upgrade. </summary>
        public string Name { get; }
        /// <summary> The catalog version namespace for the version available for upgrade. </summary>
        public string Namespace { get; }
    }
}
