// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ResourceConnector.Models
{
    /// <summary> Information about the connected appliance. </summary>
    public readonly partial struct ApplianceProvider : IEquatable<ApplianceProvider>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ApplianceProvider"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ApplianceProvider(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string VMwareValue = "VMWare";
        private const string HciValue = "HCI";
        private const string ScvmmValue = "SCVMM";

        /// <summary> VMWare. </summary>
        public static ApplianceProvider VMware { get; } = new ApplianceProvider(VMwareValue);
        /// <summary> HCI. </summary>
        public static ApplianceProvider Hci { get; } = new ApplianceProvider(HciValue);
        /// <summary> SCVMM. </summary>
        public static ApplianceProvider Scvmm { get; } = new ApplianceProvider(ScvmmValue);
        /// <summary> Determines if two <see cref="ApplianceProvider"/> values are the same. </summary>
        public static bool operator ==(ApplianceProvider left, ApplianceProvider right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ApplianceProvider"/> values are not the same. </summary>
        public static bool operator !=(ApplianceProvider left, ApplianceProvider right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ApplianceProvider"/>. </summary>
        public static implicit operator ApplianceProvider(string value) => new ApplianceProvider(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ApplianceProvider other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ApplianceProvider other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
