// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ResourceConnector.Models
{
    /// <summary> Name which contains the role of the kubeconfig. </summary>
    public readonly partial struct AccessProfileType : IEquatable<AccessProfileType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AccessProfileType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AccessProfileType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ClusterUserValue = "clusterUser";
        private const string ClusterCustomerUserValue = "clusterCustomerUser";

        /// <summary> clusterUser. </summary>
        public static AccessProfileType ClusterUser { get; } = new AccessProfileType(ClusterUserValue);
        /// <summary> clusterCustomerUser. </summary>
        public static AccessProfileType ClusterCustomerUser { get; } = new AccessProfileType(ClusterCustomerUserValue);
        /// <summary> Determines if two <see cref="AccessProfileType"/> values are the same. </summary>
        public static bool operator ==(AccessProfileType left, AccessProfileType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AccessProfileType"/> values are not the same. </summary>
        public static bool operator !=(AccessProfileType left, AccessProfileType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AccessProfileType"/>. </summary>
        public static implicit operator AccessProfileType(string value) => new AccessProfileType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AccessProfileType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AccessProfileType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
