// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ResourceConnector
{
    internal class ResourceConnectorApplianceOperationSource : IOperationSource<ResourceConnectorApplianceResource>
    {
        private readonly ArmClient _client;

        internal ResourceConnectorApplianceOperationSource(ArmClient client)
        {
            _client = client;
        }

        ResourceConnectorApplianceResource IOperationSource<ResourceConnectorApplianceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ResourceConnectorApplianceData.DeserializeResourceConnectorApplianceData(document.RootElement);
            return new ResourceConnectorApplianceResource(_client, data);
        }

        async ValueTask<ResourceConnectorApplianceResource> IOperationSource<ResourceConnectorApplianceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ResourceConnectorApplianceData.DeserializeResourceConnectorApplianceData(document.RootElement);
            return new ResourceConnectorApplianceResource(_client, data);
        }
    }
}
