// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ResourceConnector.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmResourceConnectorModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="ResourceConnector.ResourceConnectorApplianceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Identity for the resource. Current supported identity types: SystemAssigned, None. </param>
        /// <param name="distro"> Represents a supported Fabric/Infra. (AKSEdge etc...). </param>
        /// <param name="infrastructureConfigProvider"> Contains infrastructure information about the Appliance. </param>
        /// <param name="provisioningState"> The current deployment or provisioning state, which only appears in the response. </param>
        /// <param name="publicKey"> Certificates pair used to download MSI certificate from HIS. Can only be set once. </param>
        /// <param name="status"> Appliance’s health and state of connection to on-prem. </param>
        /// <param name="version"> Version of the Appliance. </param>
        /// <returns> A new <see cref="ResourceConnector.ResourceConnectorApplianceData"/> instance for mocking. </returns>
        public static ResourceConnectorApplianceData ResourceConnectorApplianceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, ResourceConnectorDistro? distro = null, ApplianceProvider? infrastructureConfigProvider = null, string provisioningState = null, string publicKey = null, ResourceConnectorStatus? status = null, string version = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ResourceConnectorApplianceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                distro,
                infrastructureConfigProvider != null ? new AppliancePropertiesInfrastructureConfig(infrastructureConfigProvider, serializedAdditionalRawData: null) : null,
                provisioningState,
                publicKey,
                status,
                version,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplianceTelemetryConfigResult"/>. </summary>
        /// <param name="telemetryInstrumentationKey"> Telemetry instrumentation key. </param>
        /// <returns> A new <see cref="Models.ApplianceTelemetryConfigResult"/> instance for mocking. </returns>
        public static ApplianceTelemetryConfigResult ApplianceTelemetryConfigResult(string telemetryInstrumentationKey = null)
        {
            return new ApplianceTelemetryConfigResult(telemetryInstrumentationKey, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplianceClusterUserCredentialResult"/>. </summary>
        /// <param name="hybridConnectionConfig"> Contains the REP (rendezvous endpoint) and “Listener” access token from notification service (NS). </param>
        /// <param name="kubeconfigs"> The list of appliance kubeconfigs. </param>
        /// <returns> A new <see cref="Models.ApplianceClusterUserCredentialResult"/> instance for mocking. </returns>
        public static ApplianceClusterUserCredentialResult ApplianceClusterUserCredentialResult(HybridConnectionConfig hybridConnectionConfig = null, IEnumerable<ApplianceCredentialKubeconfig> kubeconfigs = null)
        {
            kubeconfigs ??= new List<ApplianceCredentialKubeconfig>();

            return new ApplianceClusterUserCredentialResult(hybridConnectionConfig, kubeconfigs?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridConnectionConfig"/>. </summary>
        /// <param name="expirationTime"> Timestamp when this token will be expired. </param>
        /// <param name="hybridConnectionName"> Name of the connection. </param>
        /// <param name="relay"> Name of the notification service. </param>
        /// <param name="token"> Listener access token. </param>
        /// <returns> A new <see cref="Models.HybridConnectionConfig"/> instance for mocking. </returns>
        public static HybridConnectionConfig HybridConnectionConfig(long? expirationTime = null, string hybridConnectionName = null, string relay = null, string token = null)
        {
            return new HybridConnectionConfig(expirationTime, hybridConnectionName, relay, token, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplianceCredentialKubeconfig"/>. </summary>
        /// <param name="name"> Name which contains the role of the kubeconfig. </param>
        /// <param name="value"> Contains the kubeconfig value. </param>
        /// <returns> A new <see cref="Models.ApplianceCredentialKubeconfig"/> instance for mocking. </returns>
        public static ApplianceCredentialKubeconfig ApplianceCredentialKubeconfig(AccessProfileType? name = null, string value = null)
        {
            return new ApplianceCredentialKubeconfig(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplianceClusterUserKeysResult"/>. </summary>
        /// <param name="artifactProfiles"> Map of artifacts that contains a list of ArtifactProfile used to upload artifacts such as logs. </param>
        /// <param name="kubeconfigs"> The list of appliance kubeconfigs. </param>
        /// <param name="sshKeys"> Map of Customer User Public, Private SSH Keys and Certificate when available. </param>
        /// <returns> A new <see cref="Models.ApplianceClusterUserKeysResult"/> instance for mocking. </returns>
        public static ApplianceClusterUserKeysResult ApplianceClusterUserKeysResult(IReadOnlyDictionary<string, ApplianceArtifactProfile> artifactProfiles = null, IEnumerable<ApplianceCredentialKubeconfig> kubeconfigs = null, IReadOnlyDictionary<string, ApplianceSshKey> sshKeys = null)
        {
            artifactProfiles ??= new Dictionary<string, ApplianceArtifactProfile>();
            kubeconfigs ??= new List<ApplianceCredentialKubeconfig>();
            sshKeys ??= new Dictionary<string, ApplianceSshKey>();

            return new ApplianceClusterUserKeysResult(artifactProfiles, kubeconfigs?.ToList(), sshKeys, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplianceArtifactProfile"/>. </summary>
        /// <param name="endpoint"> Endpoint is the URL to upload artifacts to. </param>
        /// <returns> A new <see cref="Models.ApplianceArtifactProfile"/> instance for mocking. </returns>
        public static ApplianceArtifactProfile ApplianceArtifactProfile(string endpoint = null)
        {
            return new ApplianceArtifactProfile(endpoint, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplianceSshKey"/>. </summary>
        /// <param name="certificate"> Certificate associated with the public key if the key is signed. </param>
        /// <param name="creationTimeStamp"> Certificate creation timestamp (Unix). </param>
        /// <param name="expirationTimeStamp"> Certificate expiration timestamp (Unix). </param>
        /// <param name="privateKey"> Private Key. </param>
        /// <param name="publicKey"> Public Key. </param>
        /// <returns> A new <see cref="Models.ApplianceSshKey"/> instance for mocking. </returns>
        public static ApplianceSshKey ApplianceSshKey(string certificate = null, long? creationTimeStamp = null, long? expirationTimeStamp = null, string privateKey = null, string publicKey = null)
        {
            return new ApplianceSshKey(
                certificate,
                creationTimeStamp,
                expirationTimeStamp,
                privateKey,
                publicKey,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplianceUpgradeGraph"/>. </summary>
        /// <param name="id"> The appliance resource path. </param>
        /// <param name="name"> The release train name. </param>
        /// <param name="properties"> The properties of supported version. </param>
        /// <returns> A new <see cref="Models.ApplianceUpgradeGraph"/> instance for mocking. </returns>
        public static ApplianceUpgradeGraph ApplianceUpgradeGraph(string id = null, string name = null, ApplianceUpgradeGraphProperties properties = null)
        {
            return new ApplianceUpgradeGraph(id, name, properties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplianceUpgradeGraphProperties"/>. </summary>
        /// <param name="applianceVersion"> The current appliance version. </param>
        /// <param name="supportedVersions"> This contains the current version and supported upgrade versions. </param>
        /// <returns> A new <see cref="Models.ApplianceUpgradeGraphProperties"/> instance for mocking. </returns>
        public static ApplianceUpgradeGraphProperties ApplianceUpgradeGraphProperties(string applianceVersion = null, IEnumerable<ApplianceSupportedVersion> supportedVersions = null)
        {
            supportedVersions ??= new List<ApplianceSupportedVersion>();

            return new ApplianceUpgradeGraphProperties(applianceVersion, supportedVersions?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplianceSupportedVersion"/>. </summary>
        /// <param name="metadataCatalogVersion"> This is the metadata of the supported newer version. </param>
        /// <param name="version"> The newer version available for upgrade. </param>
        /// <returns> A new <see cref="Models.ApplianceSupportedVersion"/> instance for mocking. </returns>
        public static ApplianceSupportedVersion ApplianceSupportedVersion(ApplianceSupportedVersionCatalogVersion metadataCatalogVersion = null, string version = null)
        {
            return new ApplianceSupportedVersion(metadataCatalogVersion != null ? new ApplianceSupportedVersionMetadata(metadataCatalogVersion, serializedAdditionalRawData: null) : null, version, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplianceSupportedVersionCatalogVersion"/>. </summary>
        /// <param name="data"> The newer supported version catalog version data. </param>
        /// <param name="name"> The catalog version name for the version available for upgrade. </param>
        /// <param name="namespace"> The catalog version namespace for the version available for upgrade. </param>
        /// <returns> A new <see cref="Models.ApplianceSupportedVersionCatalogVersion"/> instance for mocking. </returns>
        public static ApplianceSupportedVersionCatalogVersion ApplianceSupportedVersionCatalogVersion(ApplianceSupportedVersionCatalogVersionProperties data = null, string name = null, string @namespace = null)
        {
            return new ApplianceSupportedVersionCatalogVersion(data, name, @namespace, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplianceSupportedVersionCatalogVersionProperties"/>. </summary>
        /// <param name="audience"> The image audience name for the version available for upgrade. </param>
        /// <param name="catalog"> The image catalog name for the version available for upgrade. </param>
        /// <param name="offer"> The image offer name for the version available for upgrade. </param>
        /// <param name="version"> The image version for the version available for upgrade. </param>
        /// <returns> A new <see cref="Models.ApplianceSupportedVersionCatalogVersionProperties"/> instance for mocking. </returns>
        public static ApplianceSupportedVersionCatalogVersionProperties ApplianceSupportedVersionCatalogVersionProperties(string audience = null, string catalog = null, string offer = null, string version = null)
        {
            return new ApplianceSupportedVersionCatalogVersionProperties(audience, catalog, offer, version, serializedAdditionalRawData: null);
        }
    }
}
