// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ResourceConnector.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.ResourceConnector.Samples
{
    public partial class Sample_ResourceConnectorApplianceResource
    {
        // List Appliances by subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetResourceConnectorAppliances_ListAppliancesBySubscription()
        {
            // Generated from example definition: specification/resourceconnector/resource-manager/Microsoft.ResourceConnector/stable/2022-10-27/examples/AppliancesListBySubscription.json
            // this example is just showing the usage of "Appliances_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (ResourceConnectorApplianceResource item in subscriptionResource.GetResourceConnectorAppliancesAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ResourceConnectorApplianceData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // GetTelemetryConfig Appliance
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetTelemetryConfigAppliance_GetTelemetryConfigAppliance()
        {
            // Generated from example definition: specification/resourceconnector/resource-manager/Microsoft.ResourceConnector/stable/2022-10-27/examples/TelemetryConfig.json
            // this example is just showing the usage of "Appliances_GetTelemetryConfig" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            ApplianceTelemetryConfigResult result = await subscriptionResource.GetTelemetryConfigApplianceAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Appliance
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAppliance()
        {
            // Generated from example definition: specification/resourceconnector/resource-manager/Microsoft.ResourceConnector/stable/2022-10-27/examples/AppliancesGet.json
            // this example is just showing the usage of "Appliances_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceConnectorApplianceResource created on azure
            // for more information of creating ResourceConnectorApplianceResource, please refer to the document of ResourceConnectorApplianceResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "testresourcegroup";
            string resourceName = "appliance01";
            ResourceIdentifier resourceConnectorApplianceResourceId = ResourceConnectorApplianceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ResourceConnectorApplianceResource resourceConnectorAppliance = client.GetResourceConnectorApplianceResource(resourceConnectorApplianceResourceId);

            // invoke the operation
            ResourceConnectorApplianceResource result = await resourceConnectorAppliance.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ResourceConnectorApplianceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete Appliance
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAppliance()
        {
            // Generated from example definition: specification/resourceconnector/resource-manager/Microsoft.ResourceConnector/stable/2022-10-27/examples/AppliancesDelete.json
            // this example is just showing the usage of "Appliances_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceConnectorApplianceResource created on azure
            // for more information of creating ResourceConnectorApplianceResource, please refer to the document of ResourceConnectorApplianceResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "testresourcegroup";
            string resourceName = "appliance01";
            ResourceIdentifier resourceConnectorApplianceResourceId = ResourceConnectorApplianceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ResourceConnectorApplianceResource resourceConnectorAppliance = client.GetResourceConnectorApplianceResource(resourceConnectorApplianceResourceId);

            // invoke the operation
            await resourceConnectorAppliance.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Update Appliance
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAppliance()
        {
            // Generated from example definition: specification/resourceconnector/resource-manager/Microsoft.ResourceConnector/stable/2022-10-27/examples/AppliancesPatch.json
            // this example is just showing the usage of "Appliances_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceConnectorApplianceResource created on azure
            // for more information of creating ResourceConnectorApplianceResource, please refer to the document of ResourceConnectorApplianceResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "testresourcegroup";
            string resourceName = "appliance01";
            ResourceIdentifier resourceConnectorApplianceResourceId = ResourceConnectorApplianceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ResourceConnectorApplianceResource resourceConnectorAppliance = client.GetResourceConnectorApplianceResource(resourceConnectorApplianceResourceId);

            // invoke the operation
            ResourceConnectorAppliancePatch patch = new ResourceConnectorAppliancePatch()
            {
                Tags =
{
["key"] = "value",
},
            };
            ResourceConnectorApplianceResource result = await resourceConnectorAppliance.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ResourceConnectorApplianceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ListClusterUserCredentialAppliance
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetClusterUserCredential_ListClusterUserCredentialAppliance()
        {
            // Generated from example definition: specification/resourceconnector/resource-manager/Microsoft.ResourceConnector/stable/2022-10-27/examples/AppliancesListClusterUserCredential.json
            // this example is just showing the usage of "Appliances_ListClusterUserCredential" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceConnectorApplianceResource created on azure
            // for more information of creating ResourceConnectorApplianceResource, please refer to the document of ResourceConnectorApplianceResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "testresourcegroup";
            string resourceName = "appliance01";
            ResourceIdentifier resourceConnectorApplianceResourceId = ResourceConnectorApplianceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ResourceConnectorApplianceResource resourceConnectorAppliance = client.GetResourceConnectorApplianceResource(resourceConnectorApplianceResourceId);

            // invoke the operation
            ApplianceClusterUserCredentialResult result = await resourceConnectorAppliance.GetClusterUserCredentialAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // ListKeys Appliance
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetKeys_ListKeysAppliance()
        {
            // Generated from example definition: specification/resourceconnector/resource-manager/Microsoft.ResourceConnector/stable/2022-10-27/examples/AppliancesListKeys.json
            // this example is just showing the usage of "Appliances_ListKeys" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceConnectorApplianceResource created on azure
            // for more information of creating ResourceConnectorApplianceResource, please refer to the document of ResourceConnectorApplianceResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "testresourcegroup";
            string resourceName = "appliance01";
            ResourceIdentifier resourceConnectorApplianceResourceId = ResourceConnectorApplianceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ResourceConnectorApplianceResource resourceConnectorAppliance = client.GetResourceConnectorApplianceResource(resourceConnectorApplianceResourceId);

            // invoke the operation
            ApplianceClusterUserKeysResult result = await resourceConnectorAppliance.GetKeysAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Appliance Upgrade Graph
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetUpgradeGraph_GetApplianceUpgradeGraph()
        {
            // Generated from example definition: specification/resourceconnector/resource-manager/Microsoft.ResourceConnector/stable/2022-10-27/examples/UpgradeGraph.json
            // this example is just showing the usage of "Appliances_GetUpgradeGraph" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceConnectorApplianceResource created on azure
            // for more information of creating ResourceConnectorApplianceResource, please refer to the document of ResourceConnectorApplianceResource
            string subscriptionId = "11111111-2222-3333-4444-555555555555";
            string resourceGroupName = "testresourcegroup";
            string resourceName = "appliance01";
            ResourceIdentifier resourceConnectorApplianceResourceId = ResourceConnectorApplianceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            ResourceConnectorApplianceResource resourceConnectorAppliance = client.GetResourceConnectorApplianceResource(resourceConnectorApplianceResourceId);

            // invoke the operation
            string upgradeGraph = "stable";
            ApplianceUpgradeGraph result = await resourceConnectorAppliance.GetUpgradeGraphAsync(upgradeGraph);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
