// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Reservations.Models;

namespace Azure.ResourceManager.Reservations
{
    internal partial class AzureReservationAPIRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of AzureReservationAPIRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public AzureReservationAPIRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2022-11-01";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateGetCatalogRequestUri(string subscriptionId, string reservedResourceType, AzureLocation? location, string publisherId, string offerId, string planId, string filter, float? skip, float? take)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Capacity/catalogs", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (reservedResourceType != null)
            {
                uri.AppendQuery("reservedResourceType", reservedResourceType, true);
            }
            if (location != null)
            {
                uri.AppendQuery("location", location.Value, true);
            }
            if (publisherId != null)
            {
                uri.AppendQuery("publisherId", publisherId, true);
            }
            if (offerId != null)
            {
                uri.AppendQuery("offerId", offerId, true);
            }
            if (planId != null)
            {
                uri.AppendQuery("planId", planId, true);
            }
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            if (skip != null)
            {
                uri.AppendQuery("$skip", skip.Value, true);
            }
            if (take != null)
            {
                uri.AppendQuery("$take", take.Value, true);
            }
            return uri;
        }

        internal HttpMessage CreateGetCatalogRequest(string subscriptionId, string reservedResourceType, AzureLocation? location, string publisherId, string offerId, string planId, string filter, float? skip, float? take)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Capacity/catalogs", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (reservedResourceType != null)
            {
                uri.AppendQuery("reservedResourceType", reservedResourceType, true);
            }
            if (location != null)
            {
                uri.AppendQuery("location", location.Value, true);
            }
            if (publisherId != null)
            {
                uri.AppendQuery("publisherId", publisherId, true);
            }
            if (offerId != null)
            {
                uri.AppendQuery("offerId", offerId, true);
            }
            if (planId != null)
            {
                uri.AppendQuery("planId", planId, true);
            }
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            if (skip != null)
            {
                uri.AppendQuery("$skip", skip.Value, true);
            }
            if (take != null)
            {
                uri.AppendQuery("$take", take.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get the regions and skus that are available for RI purchase for the specified Azure subscription. </summary>
        /// <param name="subscriptionId"> Id of the subscription. </param>
        /// <param name="reservedResourceType"> The type of the resource for which the skus should be provided. </param>
        /// <param name="location"> Filters the skus based on the location specified in this parameter. This can be an Azure region or global. </param>
        /// <param name="publisherId"> Publisher id used to get the third party products. </param>
        /// <param name="offerId"> Offer id used to get the third party products. </param>
        /// <param name="planId"> Plan id used to get the third party products. </param>
        /// <param name="filter"> May be used to filter by Catalog properties. The filter supports 'eq', 'or', and 'and'. </param>
        /// <param name="skip"> The number of reservations to skip from the list before returning results. </param>
        /// <param name="take"> To number of reservations to return. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<CatalogsResult>> GetCatalogAsync(string subscriptionId, string reservedResourceType = null, AzureLocation? location = null, string publisherId = null, string offerId = null, string planId = null, string filter = null, float? skip = null, float? take = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));

            using var message = CreateGetCatalogRequest(subscriptionId, reservedResourceType, location, publisherId, offerId, planId, filter, skip, take);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        CatalogsResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = CatalogsResult.DeserializeCatalogsResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get the regions and skus that are available for RI purchase for the specified Azure subscription. </summary>
        /// <param name="subscriptionId"> Id of the subscription. </param>
        /// <param name="reservedResourceType"> The type of the resource for which the skus should be provided. </param>
        /// <param name="location"> Filters the skus based on the location specified in this parameter. This can be an Azure region or global. </param>
        /// <param name="publisherId"> Publisher id used to get the third party products. </param>
        /// <param name="offerId"> Offer id used to get the third party products. </param>
        /// <param name="planId"> Plan id used to get the third party products. </param>
        /// <param name="filter"> May be used to filter by Catalog properties. The filter supports 'eq', 'or', and 'and'. </param>
        /// <param name="skip"> The number of reservations to skip from the list before returning results. </param>
        /// <param name="take"> To number of reservations to return. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<CatalogsResult> GetCatalog(string subscriptionId, string reservedResourceType = null, AzureLocation? location = null, string publisherId = null, string offerId = null, string planId = null, string filter = null, float? skip = null, float? take = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));

            using var message = CreateGetCatalogRequest(subscriptionId, reservedResourceType, location, publisherId, offerId, planId, filter, skip, take);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        CatalogsResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = CatalogsResult.DeserializeCatalogsResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetAppliedReservationListRequestUri(string subscriptionId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Capacity/appliedReservations", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetAppliedReservationListRequest(string subscriptionId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Capacity/appliedReservations", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get applicable `Reservation`s that are applied to this subscription or a resource group under this subscription. </summary>
        /// <param name="subscriptionId"> Id of the subscription. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<AppliedReservationData>> GetAppliedReservationListAsync(string subscriptionId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));

            using var message = CreateGetAppliedReservationListRequest(subscriptionId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AppliedReservationData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AppliedReservationData.DeserializeAppliedReservationData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get applicable `Reservation`s that are applied to this subscription or a resource group under this subscription. </summary>
        /// <param name="subscriptionId"> Id of the subscription. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<AppliedReservationData> GetAppliedReservationList(string subscriptionId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));

            using var message = CreateGetAppliedReservationListRequest(subscriptionId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AppliedReservationData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AppliedReservationData.DeserializeAppliedReservationData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetCatalogNextPageRequestUri(string nextLink, string subscriptionId, string reservedResourceType, AzureLocation? location, string publisherId, string offerId, string planId, string filter, float? skip, float? take)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateGetCatalogNextPageRequest(string nextLink, string subscriptionId, string reservedResourceType, AzureLocation? location, string publisherId, string offerId, string planId, string filter, float? skip, float? take)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get the regions and skus that are available for RI purchase for the specified Azure subscription. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> Id of the subscription. </param>
        /// <param name="reservedResourceType"> The type of the resource for which the skus should be provided. </param>
        /// <param name="location"> Filters the skus based on the location specified in this parameter. This can be an Azure region or global. </param>
        /// <param name="publisherId"> Publisher id used to get the third party products. </param>
        /// <param name="offerId"> Offer id used to get the third party products. </param>
        /// <param name="planId"> Plan id used to get the third party products. </param>
        /// <param name="filter"> May be used to filter by Catalog properties. The filter supports 'eq', 'or', and 'and'. </param>
        /// <param name="skip"> The number of reservations to skip from the list before returning results. </param>
        /// <param name="take"> To number of reservations to return. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="subscriptionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<CatalogsResult>> GetCatalogNextPageAsync(string nextLink, string subscriptionId, string reservedResourceType = null, AzureLocation? location = null, string publisherId = null, string offerId = null, string planId = null, string filter = null, float? skip = null, float? take = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));

            using var message = CreateGetCatalogNextPageRequest(nextLink, subscriptionId, reservedResourceType, location, publisherId, offerId, planId, filter, skip, take);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        CatalogsResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = CatalogsResult.DeserializeCatalogsResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get the regions and skus that are available for RI purchase for the specified Azure subscription. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> Id of the subscription. </param>
        /// <param name="reservedResourceType"> The type of the resource for which the skus should be provided. </param>
        /// <param name="location"> Filters the skus based on the location specified in this parameter. This can be an Azure region or global. </param>
        /// <param name="publisherId"> Publisher id used to get the third party products. </param>
        /// <param name="offerId"> Offer id used to get the third party products. </param>
        /// <param name="planId"> Plan id used to get the third party products. </param>
        /// <param name="filter"> May be used to filter by Catalog properties. The filter supports 'eq', 'or', and 'and'. </param>
        /// <param name="skip"> The number of reservations to skip from the list before returning results. </param>
        /// <param name="take"> To number of reservations to return. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="subscriptionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<CatalogsResult> GetCatalogNextPage(string nextLink, string subscriptionId, string reservedResourceType = null, AzureLocation? location = null, string publisherId = null, string offerId = null, string planId = null, string filter = null, float? skip = null, float? take = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));

            using var message = CreateGetCatalogNextPageRequest(nextLink, subscriptionId, reservedResourceType, location, publisherId, offerId, planId, filter, skip, take);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        CatalogsResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = CatalogsResult.DeserializeCatalogsResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
