// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Reservations.Models;

namespace Azure.ResourceManager.Reservations
{
    /// <summary>
    /// A class representing the ReservationDetail data model.
    /// The definition of the reservation.
    /// </summary>
    public partial class ReservationDetailData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ReservationDetailData"/>. </summary>
        internal ReservationDetailData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ReservationDetailData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> The Azure region where the reserved resource lives. </param>
        /// <param name="version"></param>
        /// <param name="sku"> The sku information associated to this reservation. </param>
        /// <param name="properties"> The properties associated to this reservation. </param>
        /// <param name="kind"> Resource Provider type to be reserved. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ReservationDetailData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, AzureLocation? location, int? version, ReservationsSkuName sku, ReservationProperties properties, ReservationKind? kind, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Location = location;
            Version = version;
            Sku = sku;
            Properties = properties;
            Kind = kind;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Azure region where the reserved resource lives. </summary>
        public AzureLocation? Location { get; }
        /// <summary> Gets the version. </summary>
        public int? Version { get; }
        /// <summary> The sku information associated to this reservation. </summary>
        internal ReservationsSkuName Sku { get; }
        /// <summary> Gets the sku name. </summary>
        public string SkuName
        {
            get => Sku?.Name;
        }

        /// <summary> The properties associated to this reservation. </summary>
        public ReservationProperties Properties { get; }
        /// <summary> Resource Provider type to be reserved. </summary>
        public ReservationKind? Kind { get; }
    }
}
