// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> The sub-request submitted with the quota request. </summary>
    public partial class SubContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SubContent"/>. </summary>
        internal SubContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SubContent"/>. </summary>
        /// <param name="limit"> Quota (resource limit). </param>
        /// <param name="name"> The resource name. </param>
        /// <param name="resourceType"> Resource type for which the quota check was made. </param>
        /// <param name="unit"> The limit units, such as **count** and **bytes**. Use the unit field provided in the response of the GET quota operation. </param>
        /// <param name="provisioningState"> The quota request status. </param>
        /// <param name="message"> User-friendly status message. </param>
        /// <param name="subRequestId"> Sub request ID for individual request. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SubContent(int? limit, ReservationResourceName name, string resourceType, string unit, QuotaRequestState? provisioningState, string message, Guid? subRequestId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Limit = limit;
            Name = name;
            ResourceType = resourceType;
            Unit = unit;
            ProvisioningState = provisioningState;
            Message = message;
            SubRequestId = subRequestId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Quota (resource limit). </summary>
        public int? Limit { get; }
        /// <summary> The resource name. </summary>
        public ReservationResourceName Name { get; }
        /// <summary> Resource type for which the quota check was made. </summary>
        public string ResourceType { get; }
        /// <summary> The limit units, such as **count** and **bytes**. Use the unit field provided in the response of the GET quota operation. </summary>
        public string Unit { get; }
        /// <summary> The quota request status. </summary>
        public QuotaRequestState? ProvisioningState { get; }
        /// <summary> User-friendly status message. </summary>
        public string Message { get; }
        /// <summary> Sub request ID for individual request. </summary>
        public Guid? SubRequestId { get; }
    }
}
