// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> Represent savings plan term in ISO 8601 format. </summary>
    public readonly partial struct SavingsPlanTerm : IEquatable<SavingsPlanTerm>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SavingsPlanTerm"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SavingsPlanTerm(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string P1YValue = "P1Y";
        private const string P3YValue = "P3Y";

        /// <summary> P1Y. </summary>
        public static SavingsPlanTerm P1Y { get; } = new SavingsPlanTerm(P1YValue);
        /// <summary> P3Y. </summary>
        public static SavingsPlanTerm P3Y { get; } = new SavingsPlanTerm(P3YValue);
        /// <summary> Determines if two <see cref="SavingsPlanTerm"/> values are the same. </summary>
        public static bool operator ==(SavingsPlanTerm left, SavingsPlanTerm right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SavingsPlanTerm"/> values are not the same. </summary>
        public static bool operator !=(SavingsPlanTerm left, SavingsPlanTerm right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SavingsPlanTerm"/>. </summary>
        public static implicit operator SavingsPlanTerm(string value) => new SavingsPlanTerm(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SavingsPlanTerm other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SavingsPlanTerm other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
