// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> The resource types. </summary>
    public readonly partial struct ResourceTypeName : IEquatable<ResourceTypeName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceTypeName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceTypeName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "standard";
        private const string DedicatedValue = "dedicated";
        private const string LowPriorityValue = "lowPriority";
        private const string SharedValue = "shared";
        private const string ServiceSpecificValue = "serviceSpecific";

        /// <summary> standard. </summary>
        public static ResourceTypeName Standard { get; } = new ResourceTypeName(StandardValue);
        /// <summary> dedicated. </summary>
        public static ResourceTypeName Dedicated { get; } = new ResourceTypeName(DedicatedValue);
        /// <summary> lowPriority. </summary>
        public static ResourceTypeName LowPriority { get; } = new ResourceTypeName(LowPriorityValue);
        /// <summary> shared. </summary>
        public static ResourceTypeName Shared { get; } = new ResourceTypeName(SharedValue);
        /// <summary> serviceSpecific. </summary>
        public static ResourceTypeName ServiceSpecific { get; } = new ResourceTypeName(ServiceSpecificValue);
        /// <summary> Determines if two <see cref="ResourceTypeName"/> values are the same. </summary>
        public static bool operator ==(ResourceTypeName left, ResourceTypeName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceTypeName"/> values are not the same. </summary>
        public static bool operator !=(ResourceTypeName left, ResourceTypeName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceTypeName"/>. </summary>
        public static implicit operator ResourceTypeName(string value) => new ResourceTypeName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceTypeName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceTypeName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
