// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> Reservation purchase details. </summary>
    public partial class ReservationToPurchaseExchange
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ReservationToPurchaseExchange"/>. </summary>
        internal ReservationToPurchaseExchange()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ReservationToPurchaseExchange"/>. </summary>
        /// <param name="reservationOrderId"> Fully qualified id of the reservationOrder being purchased. </param>
        /// <param name="reservationId"> Fully qualified id of the reservation being purchased. This value is only guaranteed to be non-null if the purchase is successful. </param>
        /// <param name="properties"> The request for reservation purchase. </param>
        /// <param name="billingCurrencyTotal"> Pricing information containing the amount and the currency code. </param>
        /// <param name="status"> Status of the individual operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ReservationToPurchaseExchange(ResourceIdentifier reservationOrderId, ResourceIdentifier reservationId, ReservationPurchaseContent properties, PurchasePrice billingCurrencyTotal, ReservationOperationStatus? status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ReservationOrderId = reservationOrderId;
            ReservationId = reservationId;
            Properties = properties;
            BillingCurrencyTotal = billingCurrencyTotal;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Fully qualified id of the reservationOrder being purchased. </summary>
        public ResourceIdentifier ReservationOrderId { get; }
        /// <summary> Fully qualified id of the reservation being purchased. This value is only guaranteed to be non-null if the purchase is successful. </summary>
        public ResourceIdentifier ReservationId { get; }
        /// <summary> The request for reservation purchase. </summary>
        public ReservationPurchaseContent Properties { get; }
        /// <summary> Pricing information containing the amount and the currency code. </summary>
        public PurchasePrice BillingCurrencyTotal { get; }
        /// <summary> Status of the individual operation. </summary>
        public ReservationOperationStatus? Status { get; }
    }
}
