// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> Reservation purchase details. </summary>
    public partial class ReservationToPurchaseCalculateExchange
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ReservationToPurchaseCalculateExchange"/>. </summary>
        internal ReservationToPurchaseCalculateExchange()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ReservationToPurchaseCalculateExchange"/>. </summary>
        /// <param name="properties"> The request for reservation purchase. </param>
        /// <param name="billingCurrencyTotal"> Pricing information containing the amount and the currency code. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ReservationToPurchaseCalculateExchange(ReservationPurchaseContent properties, PurchasePrice billingCurrencyTotal, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Properties = properties;
            BillingCurrencyTotal = billingCurrencyTotal;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The request for reservation purchase. </summary>
        public ReservationPurchaseContent Properties { get; }
        /// <summary> Pricing information containing the amount and the currency code. </summary>
        public PurchasePrice BillingCurrencyTotal { get; }
    }
}
